% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-seqQc.R
\name{subset,BarcodeQcSet-method}
\alias{subset,BarcodeQcSet-method}
\alias{[,BarcodeQcSet,ANY,ANY,ANY-method}
\title{Subset the BarcodeQcSet}
\usage{
\S4method{subset}{BarcodeQcSet}(x, i, drop = TRUE)

\S4method{[}{BarcodeQcSet,ANY,ANY,ANY}(x, i, drop = TRUE)
}
\arguments{
\item{x}{A BarcodeQcSet object}

\item{i}{A integer vector or a character vector, specifying the selected
samples.}

\item{drop}{a logical value, if TRUE, when only one sample is selected, the
output will be a BarcodeQc object.}
}
\value{
A BarcodeQcSet or BarcodeQc
}
\description{
Subset the BarcodeQcSet
}
\examples{

example_data <- system.file("extdata", "mef_test_data", package = "CellBarcode")
fq_files <- dir(example_data, "fastq.gz", full=TRUE)
qc_noFilter <- bc_seq_qc(fq_files) 
qc_noFilter[1:3]

}
