% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/class-BarcodeQc.R,
%   R/method-seqQc.R
\docType{class}
\name{bc_seq_qc}
\alias{bc_seq_qc}
\alias{bc_plot_seqQc}
\alias{BarcodeQc-class}
\alias{BarcodeQc}
\alias{BarcodeQcSet-class}
\alias{BarcodeQcSet}
\alias{bc_seq_qc,ShortReadQ-method}
\alias{bc_seq_qc,DNAStringSet-method}
\alias{bc_seq_qc,data.frame-method}
\alias{bc_seq_qc,integer-method}
\alias{bc_seq_qc,character-method}
\alias{bc_seq_qc,list-method}
\alias{bc_plot_seqQc,BarcodeQc-method}
\alias{bc_plot_seqQc,BarcodeQcSet-method}
\title{Evaluates sequences quality}
\usage{
bc_seq_qc(x, sample_name = NULL, reads_sample_size = 1e+05)

bc_plot_seqQc(x)

\S4method{bc_seq_qc}{ShortReadQ}(x, reads_sample_size = 1e+05)

\S4method{bc_seq_qc}{DNAStringSet}(x, reads_sample_size = 1e+05)

\S4method{bc_seq_qc}{data.frame}(x, reads_sample_size = 1e+05)

\S4method{bc_seq_qc}{integer}(x, reads_sample_size = 1e+05)

\S4method{bc_seq_qc}{character}(x, sample_name = basename(x), reads_sample_size = 1e+05)

\S4method{bc_seq_qc}{list}(x, sample_name = names(x))

\S4method{bc_plot_seqQc}{BarcodeQc}(x)

\S4method{bc_plot_seqQc}{BarcodeQcSet}(x)
}
\arguments{
\item{x}{A single or list of Fastq files, ShortReadQ object, DNAStringSet
object, data.frame or named integer vector.}

\item{sample_name}{A character vector with the length of sample number, used
to set the sample name.}

\item{reads_sample_size}{A integer value defines the sample size of the
sequences for quality control analysis. If there are fewer sequences comparing
to this value, all the sequences will be used. The default is 1e5.}
}
\value{
A barcodeQc or a barcodeQcSet class. 
The barcodeQc is a list with four slots, 
\itemize{
  \item \code{top}: a \code{data.frame} with top 50 most frequency sequence, 
  \item \code{distribution}: a \code{data.frame} with the distribution of
    read depth. It contains \code{nOccurrences} (depth), and \code{nReads}
    (unique sequence) columns.
  \item \code{base_quality_per_cycle}: \code{data.frame} with base-pair
    location (NGS sequencing cycle) by row, and the base-pair quality summary
    by column, including Mean, P5 (5% quantile), P25 (25% quantile), Median,
    P75 (75% quantile) and P95 (95% quantile).
  \item \code{base_freq_per_cycle}: \code{data.frame} with three columns: 1.
    \code{Cycle}, the sequence base-pair location (NGS sequencing cycle); 2.
    \code{Base}, DNA base;
    \code{Count}: reads count.
  \item{summary}: a numeric vector with following elements:
    \code{total_read}, \code{median_read_length},
    \code{p5_read_length}, \code{p95_read_length}.
}
The barcodeQcSet is a list of barcodeQc.
}
\description{
\code{bc_seq_qc} evaluates sequences quality. See the return value for detail.
}
\examples{
library(ShortRead)
# fastq file
fq_file <- system.file("extdata", "simple.fq", package="CellBarcode")
bc_seq_qc(fq_file)

# ShortReadQ
sr <- readFastq(fq_file[1])
bc_seq_qc(sr)

# DNAStringSet
ds <- sread(sr)
bc_seq_qc(ds)

# List of DNAStringSet
l <- list(sample1 = ds, sample2 = ds)
bc_plot_seqQc(bc_seq_qc(l))

# List of ShortRead
l_sr <- list(sample1 = sr, sample2 = sr)
bc_plot_seqQc(bc_seq_qc(l_sr))

###
}
