% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-plot_barcode.R
\name{bc_plot_single}
\alias{bc_plot_single}
\alias{bc_plot_single,BarcodeObj-method}
\title{Scatter plot of barcode count distribution per sample}
\usage{
bc_plot_single(
  barcodeObj,
  sample_names = NULL,
  count_marks = NULL,
  highlight = NULL,
  log_coord = TRUE,
  alpha = 0.7
)

\S4method{bc_plot_single}{BarcodeObj}(
  barcodeObj,
  sample_names = bc_names(barcodeObj),
  count_marks = NULL,
  highlight = NULL,
  log_coord = TRUE,
  alpha = 0.7
)
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} object has a cleanBc slot}

\item{sample_names}{A character vector or integer vector, specifying the
samples used for the plot.}

\item{count_marks}{A numeric or numeric vector, specifying the read count
cutoff in the scatter plot for each sample.}

\item{highlight}{A character vector, specifying the barcodes that need to be
highlighted.}

\item{log_coord}{A logical value, if TRUE (default), the \code{x} and
\code{y} coordinates of the scatter plot are transformed by log10.}

\item{alpha}{A numeric between 0 and 1, specifies the transparency of the
dots in the scatter plot.}
}
\value{
1D distribution graph matrix.
}
\description{
Draws barcode count distribution for each sample in a
BarcodeObj object.
}
\examples{
data(bc_obj) 

bc_plot_single(bc_obj, count_marks=c(10, 11))
###
}
