% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-BarcodeObj.R
\name{bc_messyBc}
\alias{bc_messyBc}
\alias{bc_messyBc,BarcodeObj-method}
\title{Accesses messyBc slot in the BarcodeObj object}
\usage{
bc_messyBc(barcodeObj, isList = TRUE)

\S4method{bc_messyBc}{BarcodeObj}(barcodeObj, isList = TRUE)
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} objects.}

\item{isList}{A logical value, if TRUE (default), the return is a list with each
sample as an element. Otherwise, the function will return a \code{data.frame}
contains the data from all the samples with a column named \code{sample_name}
to keep the sample information.}
}
\value{
If a \code{list} is requested, in the \code{list} each element is a
 \code{data.frame} corresponding to the successive samples. Each
 \code{data.frame} has at most 3 columns: 1. \code{umi_seq} (optional): UMI
sequence. 2. \code{barcode_seq}: barcode sequence. 3. \code{count}: how many
reads a full sequence has. 

If a \code{data.frame} is requested, the \code{data.frame} in the list
described above are combined into one \code{data.frame} by row, with an extra
column named \code{sample_name} for identifying sample.
}
\description{
\code{messyBc} slot of BarcodeObj object contains the raw barcode reads
frequency data. For more detail about the \code{messyBc} slot, see
\code{\link[CellBarcode]{BarcodeObj}}. \code{bc_messyBc} is used to access
the `messyBc` slot in the \code{BarcodeObj}.
}
\examples{

 data(bc_obj)
# get the data in messyBc slot
# default the return value is a list
bc_messyBc(bc_obj)

# The return value can be a data.frame
bc_messyBc(bc_obj, isList=FALSE)
###
}
