% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-cure_barcode.R
\name{bc_cure_depth}
\alias{bc_cure_depth}
\alias{bc_cure_depth,BarcodeObj-method}
\title{Filters barcodes by counts}
\usage{
bc_cure_depth(barcodeObj, depth = 0, isUpdate = TRUE)

\S4method{bc_cure_depth}{BarcodeObj}(barcodeObj, depth = 0, isUpdate = TRUE)
}
\arguments{
\item{barcodeObj}{A BarcodeObj object.}

\item{depth}{A numeric or a vector of numeric, specifying the threshold of
minimum count for a barcode to keep. If the input is a vector and the vector
length is not the same as the sample number, the element will be repeatedly
used. And when the depth argument is a number with a negative value, automatic
cutoff point will be chosen by \code{bc_auto_cutoff} function for each
samples. See \code{\link[CellBarcode]{bc_auto_cutoff}} for details.}

\item{isUpdate}{A logical value. If TRUE, the \code{cleanBc} slot in
\code{BarcodeObj} will be used preferentially, otherwise the \code{messyBc}
slot will be used. If no cleanBc is available, \code{messyBc} will be used.}
}
\value{
A \code{BarcodeObj} object with \code{cleanBc} slot updated or
created.
}
\description{
bc_cure_depth filters barcodes by the read counts or the UMI counts.
}
\examples{
data(bc_obj)

d1 <- data.frame(
    seq = c(
        "ACTTCGATCGATCGAAAAGATCGATCGATC",
        "AATTCGATCGATCGAAGAGATCGATCGATC",
        "CCTTCGATCGATCGAAGAAGATCGATCGATC",
        "TTTTCGATCGATCGAAAAGATCGATCGATC",
        "AAATCGATCGATCGAAGAGATCGATCGATC",
        "CCCTCGATCGATCGAAGAAGATCGATCGATC",
        "GGGTCGATCGATCGAAAAGATCGATCGATC",
        "GGATCGATCGATCGAAGAGATCGATCGATC",
        "ACTTCGATCGATCGAACAAGATCGATCGATC",
        "GGTTCGATCGATCGACGAGATCGATCGATC",
        "GCGTCCATCGATCGAAGAAGATCGATCGATC"
        ),
    freq = c(
        30, 60, 9, 10, 14, 5, 10, 30, 6, 4 , 6
        )
    )

pattern <- "([ACTG]{3})TCGATCGATCGA([ACTG]+)ATCGATCGATC"
bc_obj <- bc_extract(list(test = d1), pattern, sample_name=c("test"),
    pattern_type=c(UMI=1, barcode=2))

# Remove barcodes with depth < 5
(bc_cured <- bc_cure_depth(bc_obj, depth=5))
bc_2matrix(bc_cured)

# Use UMI information, filter the barcode < 5 UMI
bc_umi_cured <- bc_cure_umi(bc_obj, depth =0, doFish=TRUE, isUniqueUMI=TRUE)
bc_cure_depth(bc_umi_cured, depth = 5)

###
}
