% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-BarcodeObj.R
\name{bc_cleanBc}
\alias{bc_cleanBc}
\alias{bc_cleanBc,BarcodeObj-method}
\title{Accesses cleanBc slot in the BarcodeObj object}
\usage{
bc_cleanBc(barcodeObj, isList = TRUE)

\S4method{bc_cleanBc}{BarcodeObj}(barcodeObj, isList = TRUE)
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} objects.}

\item{isList}{A logical value, if TRUE (default), the return is a list with each sample
as an element. Otherwise, the function will return a \code{data.frame}
contains the data from all the samples with a column named \code{sample_name}
to keep the sample information.}
}
\value{
If a \code{list} is requested, each \code{list} element is a \code{data.frame}
for each sample. In a \code{data.frame}, there are 2 columns 1.
\code{barcode_seq}: barcode sequence 2. \code{counts}: reads count, or UMI
count if the \code{cleanBc} was created by \code{bc_cure_umi}.

If a \code{data.frame} is requested, the \code{data.frame} in the list
described above are combined into one \code{data.frame} by row, with an extra
column named \code{sample_name} for identifying sample.
}
\description{
\code{cleanBc} slot of BarcodeObj object contains the processed barcode reads
frequency data. For more detail about the \code{cleanBc} slot, see
\code{\link[CellBarcode]{BarcodeObj}}. \code{bc_cleanBc} is used to access
the `cleanBc` slot in the \code{BarcodeObj}.
}
\examples{

data(bc_obj)
# Get the data in cleanBc slot
# default the return value is a list
bc_cleanBc(bc_obj)

# The return value can be a data.frame
bc_cleanBc(bc_obj, isList=FALSE)
###
}
