% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleLigandReceptorAnalysis.R
\name{performLigandReceptorAnalysisPermutation}
\alias{performLigandReceptorAnalysisPermutation}
\title{Given a seurat object, a spatial graph, clusters and
species this function identifies ligand-receptor
interactions between neighbouring cells, identifies
ligand-receptor interactions within and between clusters
and calculates whether these are observed more frequently
than expected by chance using a permutation-based approach.}
\usage{
performLigandReceptorAnalysisPermutation(
  obj,
  spatialGraph,
  species,
  clusters,
  nSim = 1000,
  lrn = getLigandReceptorNetwork(species),
  minEdgesPos = 10,
  verbose = TRUE
)
}
\arguments{
\item{obj}{\itemize{
\item a Seurat object
}}

\item{spatialGraph}{\itemize{
\item a data frame of neighbouring
cell pairs.
}}

\item{species}{\itemize{
\item either 'human' or 'mouse'
}}

\item{clusters}{\itemize{
\item named vector of clusters where names are each cell and
clusters are a factor
}}

\item{nSim}{\itemize{
\item number of simulations to perform for p value calculation.
}}

\item{lrn}{\itemize{
\item a ligand-receptor network, i.e., a
data frame with columns from and to.  By default, it
retrieves the nichenetr ligand receptor network
}}

\item{minEdgesPos}{\itemize{
\item the minimum edges that need to be positive for a
ligand-receptor interaction between two clusters for a p-value to be
calculated. Only taken into consideration when the analytical method is
selected.
}}

\item{verbose}{\itemize{
\item whether to print trace, defaults to TRUE
}}
}
\value{
A list containing:
interactionsOnEdges - a sparse matrix where the rownames give pairs of
neighbouring cells and column names give ligand-receptor pairs.
Entries are TRUE if the ligand is expressed in the first cell and the receptor is expressed in
the second cell and FALSE if not.
interactionsOnEdgesMeta - a dataframe where the first two columns are the
cells that comprise the edges in interactionsOnEdges, and the next two
columns are their clusters.
totalInteractionsByCluster - a dataframe where the rownames are
sender-receiver cluster pairs and column names are ligand receptor pairs.
Entries are total numbers of edges on which particular ligand receptor
interactions are present.
meanInteractionsByCluster - a dataframe where the rownames are
sender-receiver cluster pairs and column names are ligand receptor pairs.
Entries are total numbers of edges on which particular ligand receptor i
nteractions are present (for that cluster pair) divided by the total number
of edges between those clusters.
simResults - a dataframe where the rownames are sender-receiver cluster
pairs and column names are ligand receptor pairs.
Values give the number of simulations for which observed values are greater
than simulated values.
pValues - a dataframe where the rownames are sender-receiver cluster pairs
and column names are ligand receptor pairs. Entries are uppertail p-values
describing whether a particular ligand receptor interaction is observed more
frequently between 2 clusters than expected.
totalEdges - a vector of total edges between cluster pairs.
}
\description{
Given a seurat object, a spatial graph, clusters and
species this function identifies ligand-receptor
interactions between neighbouring cells, identifies
ligand-receptor interactions within and between clusters
and calculates whether these are observed more frequently
than expected by chance using a permutation-based approach.
}
\examples{
getExample = make.getExample()
smallXenium = getExample('smallXenium')
delaunayNeighbours = getExample('delaunayNeighbours')
clusters = getExample('clusters')
performLigandReceptorAnalysis(smallXenium, delaunayNeighbours, 
                                      "mouse", clusters,  minEdgesPos = 10, nSim = 10,
                                       verbose=FALSE)
}
