% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGenesVsCells.R
\name{meanZPerClusterOnUMAP}
\alias{meanZPerClusterOnUMAP}
\title{This collects together mean z-score data together with
UMAP coordinates from the gene seurat object for plotting.}
\usage{
meanZPerClusterOnUMAP(f, fPrime, clusterBy = "seurat_clusters", layer = "data")
}
\arguments{
\item{f}{\itemize{
\item a Seurat object of cells or SingleCellExperiment to
be converted to a Seurat object
}}

\item{fPrime}{\itemize{
\item the corresponding Seurat object of genes
SingleCellExperiment to be converted to a Seurat object
}}

\item{clusterBy}{\itemize{
\item the name of the column of f@meta.data to
be used to subset the cells
}}

\item{layer}{\itemize{
\item the data layer to be used for z-scores
}}
}
\value{
This returns a data frame with the UMAP coordinates
of the gene Seurat object and the average z-score for each
gene within each of the cell clusters defined by the clusterBy
column of the meta.data of f.
}
\description{
This collects together mean z-score data together with
UMAP coordinates from the gene seurat object for plotting.
}
\examples{
getExample = make.getExample()
exSeuratObj = getExample('exSeuratObj',toy=TRUE)
STranspose = getExample('STranspose',toy=TRUE)
df = meanZPerClusterOnUMAP(exSeuratObj,STranspose,clusterBy='shortName')
}
