% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{geneSetsVsGeneClustersPValueMatrix}
\alias{geneSetsVsGeneClustersPValueMatrix}
\title{This compares the gene clusters to other gene sets
e.g., GO, Hallmark, and determines the p-value for
their overlaps when compared to a set of background
genes.}
\usage{
geneSetsVsGeneClustersPValueMatrix(
  geneSets,
  clusterDF,
  backgroundGenes,
  adjust = FALSE
)
}
\arguments{
\item{geneSets}{\itemize{
\item a named list of gene sets
}}

\item{clusterDF}{\itemize{
\item a data frame giving the cluster
membership of each gene with columns gene and geneCluster
}}

\item{backgroundGenes}{\itemize{
\item a character vector of genes
}}

\item{adjust}{\itemize{
\item a logical deciding whether to adjust
p values.  Defaults to FALSE.
}}
}
\value{
a matrix of p-values rows correspond to the gene
sets and the columns correspond the the CatsCradle gene
clusters
}
\description{
This compares the gene clusters to other gene sets
e.g., GO, Hallmark, and determines the p-value for
their overlaps when compared to a set of background
genes.
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
clusterDF = data.frame(gene=colnames(STranspose),
                       geneCluster=STranspose$seurat_clusters)
hallmark = getExample('hallmark')
geneSet = intersect(hallmark[["HALLMARK_TNFA_SIGNALING_VIA_NFKB"]],colnames(STranspose))
pvalueMatrix = geneSetsVsGeneClustersPValueMatrix(geneSet,
                                              clusterDF,
                                              colnames(STranspose))
}
