% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeometricClustering.R
\name{directedHausdorfDistance}
\alias{directedHausdorfDistance}
\title{This finds the directed Hausdorf distance from A to B}
\usage{
directedHausdorfDistance(A, B)
}
\arguments{
\item{A}{\itemize{
\item an m x d matrix representing m points in
dimension d
}}

\item{B}{\itemize{
\item an n x d matrix representing n points in
dimension d
}}
}
\value{
This returns the distance of the furthest point
in A from its nearest point in B.
}
\description{
This finds the directed Hausdorf distance from A to B
}
\examples{
A = matrix(seq_len(8),ncol=2)
B = matrix(seq(from=3,to=16),ncol=2)
d_hausdorf = directedHausdorfDistance(A,B)
}
