% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNNGraphs.R
\name{desymmetriseNN}
\alias{desymmetriseNN}
\title{This function takes the data frame of neighbor genes
and reduces it so that each undirected edge is
represented by only one directed edge.  This ensures
that randomisation does not magically split undirected
edges into two edges.}
\usage{
desymmetriseNN(NN)
}
\arguments{
\item{NN}{\itemize{
\item a dataframe containing the neighborlist
}}
}
\value{
\itemize{
\item a neighborListDF with only one directed edge per
undirected edge.
}
}
\description{
This function takes the data frame of neighbor genes
and reduces it so that each undirected edge is
represented by only one directed edge.  This ensures
that randomisation does not magically split undirected
edges into two edges.
}
\examples{
NN = make.getExample()('NN',toy=TRUE)
print(dim(NN))
NNN = desymmetriseNN(NN)
print(dim(NNN))
}
