% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoodAnalysis.R
\name{computeNBHDVsCTObject}
\alias{computeNBHDVsCTObject}
\title{This function creates a seurat object using a neighbourhood by cell type
matrix}
\usage{
computeNBHDVsCTObject(
  dataMatrix,
  resolution = 0.1,
  npcs = 10,
  n.neighbors = 30L,
  transpose = FALSE,
  verbose = TRUE,
  returnType = "Seurat"
)
}
\arguments{
\item{dataMatrix}{\itemize{
\item a matrix of neighbourhoods by cell types or its
transpose.
}}

\item{resolution}{\itemize{
\item resolution for clustering (default 0.1).
}}

\item{npcs}{\itemize{
\item number of pcs used for PCA, defaults to 10.
}}

\item{n.neighbors}{\itemize{
\item number of neighbors used by UMAP, defaults to 30.
}}

\item{transpose}{\itemize{
\item defaults to FALSE.
}}

\item{verbose}{\itemize{
\item defaults to TRUE, used to limit trace if FALSE
}}

\item{returnType}{\itemize{
\item Will return a SingleCellExperiment if this is either
of SCE, SingleCellExperiment or their lower-case equivalents.  Otherwise,
returns a Seurat object
}}
}
\value{
a seurat object based on a neighbourhood by cell type matrix or its
transpose, containing clusters and UMAP. This can also be a
SingleCellExperiment depending on the parameter returnType.
}
\description{
This function creates a seurat object using a neighbourhood by cell type
matrix
}
\examples{
NBHDByCTMatrix = make.getExample()('NBHDByCTMatrix',toy=TRUE)
NBHDByCTSeurat = computeNBHDVsCTObject(NBHDByCTMatrix)
NBHDByCTSingleCell_sce = computeNBHDVsCTObject(NBHDByCTMatrix,returnType='SCE')
}
