% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutSelection.R
\name{mutSelection}
\alias{mutSelection}
\title{mutSelection}
\usage{
mutSelection(
  maf,
  dbVAF = 0.01,
  ExAC = TRUE,
  Genomesprojects1000 = TRUE,
  ESP6500 = TRUE,
  gnomAD = TRUE,
  dbSNP = FALSE,
  keepCOSMIC = TRUE,
  keepType = "exonic",
  bedFile = NULL,
  bedHeader = FALSE,
  bedFilter = FALSE,
  progressbar = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{dbVAF}{Threshold of VAF of certain population for variants
in database. Default: 0.01}

\item{ExAC}{Whether to filter variants listed in ExAC with VAF higher than
cutoff(set in VAF parameter). Default: TRUE.}

\item{Genomesprojects1000}{Whether to filter variants listed in
Genomesprojects1000 with VAF higher than cutoff(set in VAF parameter).
Default: TRUE.}

\item{ESP6500}{Whether to filter variants listed in ESP6500 with VAF higher
than cutoff(set in VAF parameter). Default: TRUE.}

\item{gnomAD}{Whether to filter variants listed in gnomAD with VAF higher
than cutoff(set in VAF parameter). Default: TRUE.}

\item{dbSNP}{Whether to filter variants listed in dbSNP. Default: FALSE.}

\item{keepCOSMIC}{Whether to keep variants in COSMIC even
they have are present in germline database. Default: TRUE.}

\item{keepType}{A group of variant classifications will be kept,
including 'exonic', 'nonsynonymous' and 'all'. Default: 'exonic'.}

\item{bedFile}{A file in bed format that contains region information.
Default: NULL}

\item{bedHeader}{Whether the input bed file has a header or not. 
Default: FALSE.}

\item{bedFilter}{Whether to filter the information in bed file or not, which
only leaves segments in Chr1-Ch22, ChrX and ChrY. Default: FALSE}

\item{progressbar}{Whether to show progress bar when running this function
Default: TRUE}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame with variants after selection.
}
\description{
Select candidate variants for cancer research.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutSelection(maf)
}
