% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterRef.R
\name{mutFilterRef}
\alias{mutFilterRef}
\title{mutFilterRef}
\usage{
mutFilterRef(
  maf,
  reference,
  PONfile,
  PONformat = "vcf",
  tumorDP = 0,
  normalDP = 0,
  tumorAD = 0,
  normalAD = Inf,
  VAF = 0,
  VAFratio = 0,
  SBmethod = "SOR",
  SBscore = Inf,
  maxIndelLen = Inf,
  minInterval = 0,
  tagFILTER = NULL,
  dbVAF = 0.01,
  ExAC = FALSE,
  Genomesprojects1000 = FALSE,
  ESP6500 = FALSE,
  gnomAD = FALSE,
  dbSNP = FALSE,
  keepCOSMIC = FALSE,
  keepType = "all",
  bedFile = NULL,
  bedFilter = TRUE,
  mutFilter = FALSE,
  selectCols = FALSE,
  report = TRUE,
  reportFile = "FilterReport.html",
  reportDir = "./",
  TMB = FALSE,
  progressbar = TRUE,
  codelog = FALSE,
  codelogFile = "mutFilterCom.log",
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame.}

\item{reference}{A specific study whose filtering strategies
need to be referred to.
Format: "Last_name_of_the_first_author_et_al-Journal-Year-Cancer_type"
Options are: "Haraldsdottir_et_al-Gastroenterology-2014-UCEC",
"Cherniack_et_al-Cancer_Cell-2017-UCS",
"Mason_et_al-Leukemia-2015-LCML",
"Gerlinger_et_al-Engl_J_Med-2012-KIRC",
"Zhu_et_al-Nat_Commun-2020-KIRP"}

\item{PONfile}{Panel-of-Normals files, which can be either obtained through 
GATK (https://gatk.broadinstitute.org/hc/en-us/articles/360035890631-Panel-of-Normals-PON-)
or generated by users. Should have at least four columns: CHROM, POS, REF, ALT}

\item{PONformat}{The format of PON file, either "vcf" or "txt". Default: "vcf"}

\item{tumorDP}{Threshold of tumor total depth. Default: 0}

\item{normalDP}{Threshold of normal total depth. Default: 0}

\item{tumorAD}{Threshold of tumor alternative allele depth. Default: 0}

\item{normalAD}{Threshold of normal alternative allele depth. Default: Inf}

\item{VAF}{Threshold of VAF value. Default: 0}

\item{VAFratio}{Threshold of VAF ratio (tVAF/nVAF). Default: 0}

\item{SBmethod}{Method will be used to detect strand bias,
including 'SOR' and 'Fisher'. Default: 'SOR'. SOR: StrandOddsRatio
(https://gatk.broadinstitute.org/hc/en-us/articles/360041849111-
StrandOddsRatio)}

\item{SBscore}{Cutoff strand bias score used to filter variants.
Default: 3}

\item{maxIndelLen}{Maximum length of indel accepted to be included.
Default: Inf}

\item{minInterval}{Maximum length of interval between an SNV and an indel
accepted to be included. Default: 0}

\item{tagFILTER}{Variants with spcific tag in the FILTER column will be kept,
Default: NULL}

\item{dbVAF}{Threshold of VAF of certain population for variants
in database. Default: 0.01}

\item{ExAC}{Whether to filter variants listed in ExAC with VAF higher than
cutoff(set in VAF parameter). Default: TRUE.}

\item{Genomesprojects1000}{Whether to filter variants listed in
Genomesprojects1000 with VAF higher than cutoff(set in VAF parameter).
Default: TRUE.}

\item{ESP6500}{Whether to filter variants listed in ESP6500 with VAF higher
than cutoff(set in VAF parameter). Default: TRUE.}

\item{gnomAD}{Whether to filter variants listed in gnomAD with VAF higher
than cutoff(set in VAF parameter). Default: TRUE.}

\item{dbSNP}{Whether to filter variants listed in dbSNP. Default: FALSE.}

\item{keepCOSMIC}{Whether to keep variants in COSMIC even
they have are present in germline database. Default: FALSE.}

\item{keepType}{A group of variant classifications will be kept,
including 'exonic', 'nonsynonymous' and 'all'. Default: 'all'.}

\item{bedFile}{A file in bed format that contains region information.
Default: NULL.}

\item{bedFilter}{Whether to filter the information in bed file or not, which
only leaves segments in Chr1-Ch22, ChrX and ChrY. Default: TRUE}

\item{mutFilter}{Whether to directly return a filtered MAF data frame.
If FALSE, a simulation filtration process will be run, and the original MAF
data frame with tags in CaTag column, and  a filter report will be returned.
If TRUE, a filtered MAF data frame and a filter report will be generated.
Default: FALSE}

\item{selectCols}{Columns will be contained in the filtered data frame.
By default (TRUE), the first 13 columns and 'Tumor_Sample_Barcode' column.
Or a vector contains column names will be kept.}

\item{report}{Whether to generate report automatically. Default: TRUE}

\item{reportFile}{File name of the report. Default: 'FilterReport.html'}

\item{reportDir}{Path to the output report file. Default: './'}

\item{TMB}{Whether to calculate TMB. Default: TRUE}

\item{progressbar}{Whether to show progress bar when running this function
Default: TRUE}

\item{codelog}{If TRUE, your code, along with the parameters you set, 
will be export in a log file. It will be convenient for users to repeat 
experiments. Default: FALSE}

\item{codelogFile}{Where to store the codelog, only useful when codelog is
set to TRUE. Default: "mutFilterCom.log"}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame after applied filtering strategies in another study

A filter report in HTML format
}
\description{
Use the same filtering strategies that a specific study used, or
top-rated strategies shared by users.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf",package="CaMutQC"))
mafR <- mutFilterRef(maf, reference="Zhu_et_al-Nat_Commun-2020-KIRP",
PONfile=system.file("extdata","PON_test.txt", package="CaMutQC"), 
PONformat="txt", TMB=FALSE, verbose=FALSE, report=FALSE)
}
