% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mean_methylation_in_embryo}
\alias{mean_methylation_in_embryo}
\title{All genes' promoters mean methylation in embryos}
\format{
A \code{RangedSummarizedExperiment} object with 24441 rows and 492 columns
\itemize{
\item Rows correspond to all genes (gene names as rownames)
\item Mean methylation levels in embryos types are stored in columns
\item rowRanges correspond to the hg19 promoter positions
}
}
\source{
WGBS methylation data was downloaded from GEO. Mean methylation levels are
evaluated using methylation values of CpGs located in promoter region
(defined as 1000 nt upstream TSS and 500 nt downstream TSS) (see
\code{scripts/make_mean_methylation_in_embryos.R} for details).
}
\description{
Mean methylation values of all CpGs located within all genes
promoters in early embryos. Data is based on hg19 reference genome ! From
\verb{Single Cell DNA Methylome Sequencing of Human Preimplantation Embryos} (Zhu et al. 2018)
}
\details{
The rowData contains:
\itemize{
\item A column named \code{ensembl_gene_id} containing gene ids.
}
}
