% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CT_genes}
\alias{CT_genes}
\title{CT genes description table}
\format{
A \code{tibble} object with 280 rows and 47 columns.
\itemize{
\item Rows correspond to CT genes
\item Columns give CT genes characteristics
}
}
\source{
See \code{scripts/make_all_genes_prelim.R} and
\code{scripts/make_all_genes_and_CT_genes.R}for details on how this list of
curated CT genes was created.
}
\description{
Cancer-Testis (CT) genes description
}
\details{
When the promoter is mentionned, it has been determined as 1000 nt
upstream TSS and 200 nt downstream TSS.

CT_genes characteristics column:
\itemize{
\item Column \code{CT_gene_type} indicates if the gene is a CT specific gene
("CT_gene" : testis_specific in \code{testis_specificity}) and activated in
"TCGA_category" and "CCLE_category) or CT preferential gene ("CTP_gene" :
testis_preferential in \code{testis_specificity}) and activated in"TCGA_category"
and "CCLE_category").
\item Column \code{testis_specificity} gives the testis-specificity of genes
assigned to each gene using \code{GTEX_category} and \code{multimapping_analysis}
("testis_specific" or "testis_preferential"). Genes were assigned
"testis-preferential" if testis-specific in these categories but not testis
specific in \code{HPA_category} or leaky in \code{CCLE_category} or \code{TCGA_category}.
\item Column \code{regulated_by_methylation} indicates if the gene is
regulated by methylation (\code{TRUE}) based on DAC induction (has to
be TRUE) and on promoter methylation level in normal somatic tissues
(when available, has to be methylated in somatic tissues).
\item Column \code{X_linked} indicates if the gene is on the chromosome X
(TRUE) or not (FALSE).
\item Columns \code{chr}, \code{strand} and \code{transcription_start_site} give the
genomic location.
\item Column \code{GTEX_category} gives the category ("testis_specific",
"testis_preferential" or "lowly_expressed") assigned to each gene
using GTEx database (see \code{?GTEX_data} for details).
\item Column \code{q75_TPM_somatic} gives the q75 expression level found
in a somatic tissue (using GTEx database).
\item Column \code{max_TPM_somatic} gives the maximum expression level found
in a somatic tissue (using GTEx database).
\item Column \code{ratio_testis_somatic} gives the ratio between expression in testis
and the highest expression found in a somatic tissue (using GTEx database).
\item Column \code{TPM_testis} gives the gene expression level in testis
(using GTEx database).
\item Column \code{lowly_expressed_in_GTEX} indicates if the gene is lowly
expressed in GTEX database and thus needed to be analysed with
multimapping allowed.
\item Column \code{multimapping_analysis} informs if the gene (flagged as
"lowly_expressed" in GTEX_data) was found to be testis-specific
when multi-mapped reads were counted for gene expression in
normal tissues ("not_analysed" or "testis_specific") (see
\code{?normal_tissues_multimapping_data} for details).
\item Column \code{HPA_RNA_single_cell_type_specific_nTPM} specifies the cell types in
which genes were detected in the HPA single cell data (see
\code{?HPA_cell_type_specificity} for details).
\item Column \code{max_HPA_germcell} specifies if the maximum expression value in a
germ cell type. (see  \code{?HPA_cell_type_specificity} for details).
\item Column \code{max_HPA_somatic} specifies if the maximum expression value in a
somatic cell type. (see  \code{?HPA_cell_type_specificity} for details).
\item Column \code{not_detected_in_somatic_HPA} specifies if the gene is detected or
not in a somatic cell type. (see  \code{?HPA_cell_type_specificity} for details).
\item Column \code{HPA_ratio_germ_som} gives the ratio between \code{max_HPA_germcell} and
\code{max_HPA_somatic} columns.
\item Column \code{percent_of_positive_CCLE_cell_lines} gives the percentage
of CCLE cancer cell lines in which genes are expressed (genes
were considered as expressed if TPM >= 1).
\item Column \code{percent_of_negative_CCLE_cell_lines} gives the percentage
of CCLE cancer cell lines in which genes are repressed (TPM <=
0.5).
\item Column \code{max_TPM_in_CCLE} gives the highest expression level of
genes in CCLE cell lines.
\item Column \code{CCLE_category} gives the category assigned to each gene
using CCLE data. "Activated" category corresponds to genes
expressed in at least 1\% of cell lines (TPM >= 1) and repressed in
at least 20\% of cell lines.
\item Column \code{percent_pos_tum} gives the percentage of TCGA cancer
samples in which genes are expressed (genes were considered as
expressed if TPM >= 1).
\item Column \code{percent_neg_tum} gives the percentage of TCGA cancer samples in
which genes are repressed (TPM <= 0.5).
\item Column \code{max_TPM_in_TCGA} gives the highest expression level of
genes in TCGA cancer sample.
\item Column \code{max_q75_in_NT} gives the maximum q75 expression in normal
peritumoral tissues from TCGA.
\item Column \code{TCGA_category} gives the category assigned to each gene
using TCGA data. "activated" category corresponds to genes
expressed in at least 1\% of tumors (TPM >= 1) and repressed in at
least 20\% of samples.  "multimapping_issue" corresponds to genes
that need multi-mapping to be allowed in order to be analysed
properly.
\item Columns \code{external_transcript_name}, \code{ensembl_transcript_id}, and
\code{transcript_biotype} give the references and informations about
the most biologically relevant transcript associated to each
gene.
\item Column \code{IGV_backbone} indicates if a gene has been removed from CT genes
as RNA-Seq reads were not properly aligned on exons, but were instead
spread across a wide genomic region spanning the genes.
\item Column \code{family} gives the gene family name.
\item Column \code{DAC_induced} summarises the results (\code{TRUE} or \code{FALSE})
of a differential expression evaluating gene induction upon DAC
treatment in a series of cell lines.
\item Column named \code{CpG_density}, gives the density of CpG within each
promoter (number of CpG / promoter length * 100).
\item Column \code{CpG_promoter} classifies the promoters according to their
CpG densities: "low" (CpG_density < 2), "intermediate"
(CpG_density >= 2 & CpG_density < 4), and "high" (CpG_density >=
4).
\item Column \code{somatic_met_level} that gives the mean methylation level
of each promoter in somatic tissues.
\item Column \code{sperm_met_level} that gives the methylation level of each
promoter in sperm.
\item Column \code{somatic_methylation} indicates if the promoter's mean
methylation level in somatic tissues is higher than 50\%.
\item Column \code{germline_methylation}indicates if the promoter is
methylated in germline, based on the ratio with somatic tissues
(\code{FALSE} if somatic_met_level is at least twice higher than
\code{germline_met_level}).
\item Columns \code{oncogene} and \code{tumor_suppressor} informs if oncogenic
and tumor-suppressor functions have been associated to genes
(source: \href{http://bionlp.bcgsc.ca/cancermine/}{Cancermine}).
}
}
