% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOfftargetScore.R
\name{getOfftargetScore}
\alias{getOfftargetScore}
\title{Calculate score for each off target}
\usage{
getOfftargetScore(
  featureVectors,
  weights = c(0, 0, 0.014, 0, 0, 0.395, 0.317, 0, 0.389, 0.079, 0.445, 0.508, 0.613,
    0.851, 0.732, 0.828, 0.615, 0.804, 0.685, 0.583)
)
}
\arguments{
\item{featureVectors}{a data frame generated from
buildFeatureVectorForScoring. It contains}

\item{weights}{a numeric vector size of gRNA length, default c(0, 0, 0.014,
0, 0, 0.395, 0.317, 0, 0.389, 0.079, 0.445, 0.508, 0.613, 0.851, 0.732,
0.828, 0.615, 0.804, 0.685, 0.583) which is used in Hsu et al., 2013 cited
in the reference section}
}
\value{
A data frame containing details of off-targets for the given gRNA.
\itemize{
 \item IsMismatch.posX - Indicator variable indicating whether this position 
 X is a mismatch or not, (1 means yes and 0 means no). X takes on values from 
 1 to gRNA.size, representing all positions in the guide RNA (gRNA).
 \item strand - strand of the off-target, + for plus and - for minus strand
 \item chrom - chromosome of the off-target
 \item chromStart - start position of the off-target
 \item chromEnd - end position of the off-target
 \item name - gRNA name
 \item gRNAPlusPAM - gRNA sequence with PAM sequence concatenated
 \item OffTargetSequence - the genomic sequence of the off-target
 \item n.mismatch - number of mismatches between the off-target and the gRNA
 \item forViewInUCSC - string for viewing in UCSC genome browser, e.g., 
 chr14:31665685-31665707
 \item score - score of the off-target
 \item mismatch.distance2PAM - comma-separated distances of all mismatches 
 to PAM, e.g., 14,11 means one mismatch is 14 bp away from PAM and the other 
 mismatch is 11 bp away from PAM
 \item alignment - alignment between gRNA and off-target, 
 e.g., ......G..C.......... means that this off-target aligns with gRNA 
 except that G and C are mismatches
 \item NGG - whether this off-target contains canonical PAM (1 for yes, 
 0 for no)
 \item mean.neighbor.distance.mismatch - mean distance between neighboring 
 mismatches
}

A data frame containing details of off-targets for the given gRNA.
\itemize{
 \item strand - strand of the match, + for plus and - for minus strand
 \item chrom - chromosome of the off-target
 \item chromStart - start position of the off-target
 \item chromEnd - end position of the off-target
 \item name - gRNA name
 \item gRNAPlusPAM - gRNA sequence with PAM sequence concatenated
 \item OffTargetSequence - the genomic sequence of the off-target
 \item n.mismatch - number of mismatches between the off-target and the gRNA
 \item forViewInUCSC - string for viewing in UCSC genome browser, e.g., 
 chr14:31665685-31665707
 \item score - score of the off-target
 \item mismatch.distance2PAM - comma-separated distances of all mismatches 
 to PAM, e.g., 14,11 means one mismatch is 14 bp away from PAM and the other 
 mismatch is 11 bp away from PAM
 \item alignment - alignment between gRNA and off-target, 
 e.g., ......G..C.......... means that this off-target aligns with gRNA 
 except that G and C are mismatches
 \item NGG - whether this off-target contains canonical PAM (1 for yes, 
 0 for no)
 \item mean.neighbor.distance.mismatch - mean distance between neighboring 
 mismatches
}
}
\description{
Calculate score for each off target with given feature vectors and weights
vector
}
\details{
score is calculated using the weights and algorithm by Hsu et al., 2013
cited in the reference section
}
\examples{

    hitsFile <-  system.file("extdata", "hits.txt", 
        package = "CRISPRseek")
    hits <- read.table(hitsFile, sep = "\t", header = TRUE,
        stringsAsFactors = FALSE)
    featureVectors <- buildFeatureVectorForScoring(hits)
    getOfftargetScore(featureVectors)
}
\references{
Patrick D Hsu, David A Scott, Joshua A Weinstein, F Ann Ran,
Silvana Konermann, Vineeta Agarwala, Yinqing Li, Eli J Fine, Xuebing Wu,
Ophir Shalem, Thomas J Cradick, Luciano A Marraffini, Gang Bao & Feng Zhang
(2013) DNA targeting specificity of rNA-guided Cas9 nucleases. Nature
Biotechnology 31:827-834
}
\seealso{
offTargetAnalysis
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
