% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{pathEstimator}
\alias{pathEstimator}
\title{pathEstimator}
\usage{
pathEstimator(data, path.start = 1, path.type = c("circular",
  "clockwise"), joinedGroups = NULL)
}
\arguments{
\item{data}{List. The output of Fluo_inspection().}

\item{path.start}{Integer. A cluster number indicating the starting cluster that algorithm should use to
build the path. The cluster numbers refer to the plot generated by Fluo_inspection(). Default is 1.
If path.type = "circular" the number does not matter. If path.type = "A2Z" the user should inspect the
Fluo_inspection() plot to detect the beginning of the path. If path.type = "other", the function will
not estimate a path. The user has to manually insert the path progression (the cluster numbers) in
Fluo_modeling().}

\item{path.type}{Character vector. A user-defined vector that characterizes the cell progression dynamics.
  The first element can be either "circular" or "A2Z" or "other". If "circular" the path progression is
  assummed to exhibit a circle-like behavior. If "A2Z" the path is assumed to have a well-defined start
  and a well-defined end point (e.g. a linear progression). If "other" the progression is assumed to be
  arbitrary without an obvious directionality. Default is "circular".
  The second element can be either "clockwise" or "anticlockwise" depending on how the path is expected
  to proceed. Default is "clockwise". If the first element is "other" the second element can be ommited.

  If path.type = "other", the function does not estimate a path. The exact path has to be manually inserted
  in Fluo_modeling().}

\item{joinedGroups}{List. A list of cluster numbers to join. E.g. list(c(2,4)) joins cluster 2 and 4 as depicted
in the Fluo_inspection() plot. Alternatively, list(c(2,4),c(1,6)) joins cluster 2 and 4 and clusters 1 and 6
as depicted in the Fluo_inspection() plot.Each list entry should contain 2 groups. Default is NULL.}
}
\value{
The list of adjusted signal estimates, a progression path and the defined path type. The output is
  essentially the output of Fluo_inspection() with the addition of the following components:
  Path: the estimated path (visualized in the Fluo_Inspection() helper plot).
  path.type: the path.type that has been used to estimate the path.
}
\description{
It reads the generated groups of Fluo_inspection() and estimates the path cell progression
  given a user-defined expected pattern. It can also join some of the groups into a single one (manual
  selection is required).
}
\examples{
step3.1 <- pathEstimator(step3,path.start=6,path.type=c("circular","clockwise"))
}
