% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{getFluo_byRun}
\alias{getFluo_byRun}
\title{getFluo_byRun}
\usage{
getFluo_byRun(data, BGmethod = "normexp", areacut = 0,
  transformation = "log", savePlot = getwd())
}
\arguments{
\item{data}{List. The output of createFluo().}

\item{BGmethod}{Character string. The type of image background correction to be performed.
One of "normexp" or "subtract". Default is "normexp".}

\item{areacut}{Integer. The "artificial" area size (BFarea^2) of the cells estimated
by BF image modelling. Default is 0, implying that the area sizes to be corrected will
by estimated automatically from the data (not recommended if prior knowledge exists).}

\item{transformation}{Character string. One of bc (Box-Cox), log, log10, asinh transforms
applied to the data. Default is "log".}

\item{savePlot}{Character string. Directory to store the plots. Its value can be an existing directory
or "screen" that prints the plot only on the screen or "OFF" that does not generate a plot (suggested
only during cross-validations). Default is the current working directory, getwd().}
}
\value{
A list of corrected signal estimates. The slots are the same to those of getFluo():
  index: The sample indices.
  samples: the sample IDs.
  batch: a matrix of the run IDs. The first column contains the original run IDs. The second column is the converted
      original IDs into numeric values (to be used in the statistical modeling step of Fluo_adjustment()).
  Size: the estimated cell size.
  corrected.exprs: the background corrected channel signals (case of a single run).
  corrected.transformed.exprs: the background transformed corrected channel signals (case of a single run). The
    transformation is defined in the transformation parameter.
  correctedAreas: the log-transformed areas after correction and imputation.
  areacut: the above areacut if different from 0 or the automatically calulated one otherwise.
  transformation: the transformation applied on the fluorescence signals.
  image.type: the image type IDs as defined in readFiles(). The parameter is kept in order to enable the user to
    use this function independently of the image analysis step.
  dateIndex: the date index used.
  single.batch.analysis: it returns 0 because there is no run effect correction done.
  BGmethod: the background correction methods used.
  maxMix: it returns NULL because there is no flexmix run effect correction done.
  prior.pi: it returns NULL because there is no flexmix run effect correction done.
  flex.reps: it returns NULL because there is no flexmix run effect correction done.
  flexmethod: it returns NULL because there is no flexmix run effect correction done.
  RNG: the seed that is used to generate the results.
}
\description{
It produces the background corrected data when run correction is not needed. It can
  be used for data coming from a single run instead of Fluo_adjustment().
  Alternatively, this function can be used to visualize the fluorescence
  densities of a single batch before deciding the form of the normalization
  model.
}
\examples{
step1 <- createFluo(from.file=system.file("extdata", "Results_of_image_analysis.txt",
package = "CONFESS"),separator="_")

### select the samples of a single run and correct them
step2a <- FluoSelection_byRun(data = step1, batch = 5)
step2.1 <- getFluo_byRun(data=step2a,savePlot="OFF")
}
