% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_fluo_NBE.R
\name{GAPanalysis}
\alias{GAPanalysis}
\title{GAPanalysis}
\usage{
GAPanalysis(data, fixClusters, sigma, altFUN, k.max, B.kmeans, savePlot,
  seed)
}
\arguments{
\item{data}{List. A list of adjusted fluorescence signals. Typically, the output of summarizeAdjFluo().}

\item{fixClusters}{Integer. A number that defines the number of k-mean clusters to be initially generated.
If 0, the function runs GAP analysis to estimate the optimal number of clusters.}

\item{sigma}{Integer. A value for the sigma parameter of samSPECTRAL algorithm.}

\item{altFUN}{Character string. A user-defined method to generate the initial clusters. It can be one of
kmeans, samSpec, fmeans,fmerge or fpeaks.}

\item{k.max}{Integer. This is the maximum number of clusters that can be generated by k-means (if
fixClusters = 0).}

\item{B.kmeans}{Integer. The number of bootstrap samples for GAP analysis in altFUN = kmeans.}

\item{savePlot}{Character string. The directory to store the plots or an option to print them on the screen.}

\item{seed}{Integer. An optional seed number for the Random Number Generator.}
}
\value{
A list of adjusted fluorescence signals with cluster indices and outlier indicators (the 2s in
  the second column of GAPgroups).
}
\description{
It perfomrs GAP analysis using different methods. It generates the cluster numbers an an indicator of outliers.
}
\keyword{internal}
