% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{Fluo_inspection}
\alias{Fluo_inspection}
\title{Fluo_inspection}
\usage{
Fluo_inspection(data, altFUN = "kmeans", fixClusters = 0,
  SAM.sigma = 200, k.max = 15, B.kmeans = 50, savePlot = getwd(),
  seed = NULL)
}
\arguments{
\item{data}{List. The output of getFluo() or getFluo_byRun().}

\item{altFUN}{Character string. A user-defined method to generate the initial clusters. It can be one of
kmeans, samSpec, fmeans,fmerge or fpeaks. Default is "kmeans".}

\item{fixClusters}{Integer. A number that defines the number of k-mean clusters to be initially generated.
If 0, the function runs GAP analysis to estimate the optimal number of clusters. Default is 0.}

\item{SAM.sigma}{Integer. A value for the sigma parameter of SamSPECTRAL algorithm. Default is 200.}

\item{k.max}{Integer. This is the maximum number of clusters that can be generated by k-means (if
fixClusters = 0). Default is 15.}

\item{B.kmeans}{Integer. The number of bootstrap samples for the calculation of the GAP statistic. Default is 50.}

\item{savePlot}{Character string. Directory to store the plots. Its value can be an existing directory
or "screen" that prints the plot only on the screen or "OFF" that does not generate a plot (suggested
only during cross-validations). Default is the current working directory, getwd().}

\item{seed}{Integer. An optional seed number for the Random Number Generator. Note that this seed is a 'reference'
value of the actual seed used in sampling. CONFESS is using various random sampling methods. Each method's
actual seed is factor*seed. The factors vary across methods. Default is NULL.}
}
\value{
A list of corrected fluorescence signal estimates and a helper plot for deciding the number of groups and
  the cell progression path. The output is essentially the output of getFluo() or getFluo_byRun() with the addition
  of the following components:
  GAPgroups: the groups estimated by one of the altFUN methods are depicted in the first column. The second column contains
    1s for non-outlier signals and 2s for outlier signals (as estimated by each of the methods).
  clusterFUN: the altFUN method that has been used for clustering.
  normal.sigma: the sigma parameter of samSpec method.
  centroids: the 2 dimensional medians (centroids) of the estimated clusters.
  fixClusters: the fixClusters parameter used.
  Kmax: the k.meax parameter used.
  B.kmeans: the B.kmeans parameter used
}
\description{
It generates the initial cell clusters as defined by their corrected fluorescence signals. The clusters
  can be generated by k-means (with GAP statistic estimated number of clusters) or by flow
  cytometry based approaches. This function shows the number and the characteristics of the
  initial groups and help us inspect cells' progression type for pathEstimator().
}
\examples{
step3 <- Fluo_inspection(data=step2.1,altFUN="kmeans",B.kmeans=5,savePlot="OFF")
}
