% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{FluoSelection_byRun}
\alias{FluoSelection_byRun}
\title{FluoSelection_byRun}
\usage{
FluoSelection_byRun(data, batch = c(), other = c())
}
\arguments{
\item{data}{List. The output of createFluo().}

\item{batch}{Integer. A selected run. If it is c() then the "other" parameter should be activated. Default
is 1.}

\item{other}{Numeric vector. It accepts the sample numbers indicating the samples to be kept for analysis,
e.g. other = c(1:10, 101:110) to keep samples 1:10 and 100:110. Default is c().}
}
\value{
A list of reformed data to be used in subsequent analysis. It is essentially the same slots of createFluo()
 with only a subset of data included (as defined by the batch and other parameters):
  index: The sample indices.
  RGexprs: the foreground (columns 1 and 3) and background (columns 2 and 4) signals of each channel that
    have been estimated by spotEstimator() and filtered in LocationMatrix().
  samples: the sample IDs.
  batch: a matrix of the run IDs. The first column contains the original run IDs. The second column is the converted
    original IDs into numeric values (to be used in the statistical modeling step of Fluo_adjustment()).
  size: the estimated cell size.
  image.type: the image type IDs as defined in readFiles(). The parameter is kept in ordeer to enable the user to
    use this function independently of the image analysis step.
  dateIndex: a date index to be used for storing the output files. It is either transfered from LocationMatrix() or
    it is generated here for the first time (e.g. if image analysis was not run by CONFESS or if the analysis has
    been repeated many times).
}
\description{
It accepts a subset of data to inspect their background corrected fluorescence signal characteristics.
  Typically it one can inout the data from a single run to identify an appropriate mixture model for
  run effect correction. Any other arbitrary subset of the data can also be used. For example, it can
  be used to keep certain samples and filter out outliers.
}
\examples{
step1 <- createFluo(from.file=system.file("extdata", "Results_of_image_analysis.txt",
                   package = "CONFESS"),separator="_")
step2a <- FluoSelection_byRun(data = step1, batch = 4:5)
}
