% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSetToCOMPASS.R
\name{COMPASSContainerFromGatingSet}
\alias{COMPASSContainerFromGatingSet}
\title{Create a COMPASS Container from a GatingSet}
\usage{
COMPASSContainerFromGatingSet(
  gs = NULL,
  node = NULL,
  filter.fun = NULL,
  individual_id = "PTID",
  mp = NULL,
  matchmethod = c("Levenshtein", "regex"),
  markers = NA,
  swap = FALSE,
  countFilterThreshold = 5000
)
}
\arguments{
\item{gs}{a \code{GatingSet} or \code{GatingSetList}}

\item{node}{a \code{regular expression} to match a single node in the gating tree. If more than one node is matched, an error is thrown.}

\item{filter.fun}{a \code{function} that does string substitution to clean up node names, i.e. turns a 'CD4+' into a 'CD4' to try and
match against the \code{parameters} slot of the \code{flowFrames} in \code{gs}}

\item{individual_id}{a \code{character} identifying the subject id column in the \code{gs} metadata}

\item{mp}{a \code{list} mapping node names to markers. This function tries to guess, but may fail. The user can override the guesswork.}

\item{matchmethod}{a \code{character} either 'regex' or 'Levenshtein' for matching nodes to markers.}

\item{markers}{a \code{character} vector of marker names to include.}

\item{swap}{a \code{logical} default FALSE. Set to TRUE if the marker and channel names are swapped.}

\item{countFilterThreshold}{\code{numeric} threshold. if the number of parent cells
is less than this threshold, we remove that
 file. Default is 5000.}
}
\description{
This code expects a \code{GatingSet} or \code{GatingSetList}.
It expects a regular expression for the node name
(i.e. '/4\\+$' would match '/4+' in a node name with the plus
sign at the end of the string. Alternatively, you can supply a
partial path.
The user must supply the 'individual_id', which has the default value suitable for the data we commonly see.
'sample_id' is the 'rownames' of 'pData' of 'GatingSet'.
Sometimes the child node names don't match the marker names exactly.
This function will try to make some guesses about how to match these up.
The \code{filter.fun} parameter is a function that does some regular expression string
substitution to try and clean up the node names by removing
various symobls that are often added to gates, \{+/-\}. The user can provide their
own function to do string cleanup.
Counts are extracted as well as metadata and single cell data, and these are fed into the
\code{COMPASSContainer} constructor.
}
\details{
There is likely not sufficient error checking.
}
\examples{
\dontrun{
## gs is a GatingSet from flowWorkspace
COMPASSContainerFromGatingSet(gs, "4+")
}
}
\seealso{
\code{\link{COMPASSContainer}}
}
