% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchCNViz.R
\name{launchCNViz}
\alias{launchCNViz}
\title{Launches CNViz, a shiny app to visualize your sample's copy number data.}
\usage{
launchCNViz(
  sample_name = "sample",
  probe_data = data.frame(),
  gene_data = data.frame(),
  segment_data = data.frame(),
  variant_data = data.frame(),
  meta_data = data.frame()
)
}
\arguments{
\item{sample_name}{A string with the ID/name of your sample.}

\item{probe_data}{A dataframe or GRanges object containing probe-level data. If a dataframe, column names must include chr, gene, start, end, log2. chr/seqnames column should be formatted as 'chr1' through 'chrX', 'chrY'. start, end and log2 should be numeric. If a GRanges object, gene and log2 are metadata columns. Optional column/metadata: weight, where weight is numeric.}

\item{gene_data}{A dataframe or GRanges object containing gene-level data - one row per gene. If a dataframe, column names must include chr, gene, start, end, log2. chr/seqnames column should be formatted as 'chr1' through 'chrX', 'chrY'. start, end and log2 should be numeric. If a GRanges object, gene and log2 are metadata columns. Optional columns/metadata: weight, loh; where weight is numeric and loh values are TRUE or FALSE.}

\item{segment_data}{A dataframe or GRanges object containing segment-level data. If a dataframe, column names must include chr, start, end, log2. chr column should be formatted as 'chr1' through 'chrX', 'chrY'. start, end and log2 should be numeric. If a GRanges object, log2 is a metadata column. Optional column/metadata: loh; where loh values are TRUE or FALSE.}

\item{variant_data}{A dataframe or VRanges object containg SNVs and short indels and columns of your choosing. If a dataframe, the only required columns are gene and mutation_id. Optional column: start; where start indicates the starting position of the mutation. If a VRanges object, make sure gene is one of the metadata columns, so it can be tied to the gene or probe data; a mutation_id column can also be included, otherwise it will be constructed. Additional columns might include depth, allelic_fraction, ref, alt.}

\item{meta_data}{A dataframe containing your sample's metadata - columns of your choosing. Optional column: ploidy; ploidy will be rounded to the nearest whole number. Additional columns might include purity. This dataframe should only have one row.}
}
\value{
a Shiny application
}
\description{
CNViz launches a shiny application to visualize your sample's copy number data.
At least one of probe_data, gene_data, or segment_data must be supplied;
sample_name, variant_data and meta_data are all optional. The more inputs supplied,
the more informative the application will be. See the CNViz vignette for more information.
Use the hg38 reference genome. CNViz only displays a single sample's data.
}
\examples{
probes <- data.frame(chr = c("chr1", "chr1", "chr4", "chr4", "chrX"),
gene = c("NOTCH2", "NOTCH2", "KIT", "TET2", "BTK"),
start = c(119922221, 119967406,54732072,105243553,101360541),
end = c(119922461,119967646,54732192,105243793,101360781),
log2 = c(-0.0832403,-0.0578757,0.2131540,-0.3189430,-0.7876670),
weight = c(0.684114, 0.681546,0.606129,0.682368,0.405772))
segments <- data.frame(chr = c("chr1","chr1", "chr4", "chr4", "chrX"),
start = c(1050069, 124932724,   1942322,  51743951,   1198732),
end = c(122026459, 246947668,  49712061, 188110779,  37098762),
log2 = c(1, 1, 1, 1, 0.5849625), loh = c(FALSE, FALSE, FALSE, TRUE, TRUE))
meta <- data.frame(purity = c(.5),
ploidy = c(2), sex = c("Female"))
\donttest{
launchCNViz(sample_name = "sample123", probe_data = probes,
segment_data = segments, meta_data = meta)
}

}
