% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSNPsFromVCF.R
\name{loadSNPsFromVCF}
\alias{loadSNPsFromVCF}
\title{loadSNPsFromVCF}
\usage{
loadSNPsFromVCF(
  vcf.file,
  vcf.source = NULL,
  ref.support.field = NULL,
  alt.support.field = NULL,
  list.support.field = NULL,
  regions.to.filter = NULL,
  genome = "hg19",
  exclude.non.canonical.chrs = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{vcf.file}{VCF file path}

\item{vcf.source}{VCF source, i.e., the variant caller used to generate the VCF file. If set, the function will not try to recognize the source. (Defaults to NULL)}

\item{ref.support.field}{Reference allele depth field. (Defaults to NULL)}

\item{alt.support.field}{Alternative allele depth field. (Defaults to NULL)}

\item{list.support.field}{Allele support field in a list format: reference allele, alternative allele. (Defaults to NULL)}

\item{regions.to.filter}{The regions to which limit the VCF import. It can be used to speed up the import process. (Defaults to NULL)}

\item{genome}{The name of the genome (Defaults to "hg19")}

\item{exclude.non.canonical.chrs}{Whether to exclude non canonical chromosomes (Defaults to TRUE)}

\item{verbose}{Whether to show information messages. (Defaults to TRUE)}
}
\value{
A list where names are sample names, and values are \code{GRanges} objects containing the variants for each sample, including the following metadata columns:
\itemize{
 \item \code{ref.support}: Reference allele depth field
 \item \code{alt.support}: Alternative allele depth field
 \item \code{alt.freq}: allelic frequency
 \item \code{total.depth}: total depth
}
}
\description{
Loads SNPs (SNVs/indels) from a VCF file
}
\details{
Given a VCF file path, the function recognizes the variant caller source to decide which fields should be used to calculate
ref/alt support and allelic frequency (see \code{return}). Current supported variant callers are VarScan2, Strelka/Strelka2, freebayes,
HaplotypeCaller, UnifiedGenotyper and Torrent Variant Caller.

Optionally, the fields where the data is stored can be manually set by using the parameters \code{ref.support.field},
\code{alt.support.field} and \code{list.support.field}

Requirement: a TabixFile (.tbi) should exists in the same directory of the VCF file.
}
\examples{
vcf.file <- system.file("extdata", "variants.sample1.vcf.gz", package = "CNVfilteR", mustWork = TRUE)
vcf <- loadSNPsFromVCF(vcf.file)

}
