% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCNVcalls.R
\name{loadCNVcalls}
\alias{loadCNVcalls}
\title{loadCNVcalls}
\usage{
loadCNVcalls(
  cnvs.file,
  chr.column,
  start.column,
  end.column,
  coord.column = NULL,
  cnv.column,
  sample.column,
  sample.name = NULL,
  gene.column = NULL,
  deletion = "deletion",
  duplication = "duplication",
  ignore.unexpected.rows = FALSE,
  sep = "\\t",
  skip = 0,
  genome = "hg19",
  exclude.non.canonical.chrs = TRUE,
  check.names.cnvs.file = FALSE
)
}
\arguments{
\item{cnvs.file}{Path to csv/tsv file containing the CNV calls.}

\item{chr.column}{Which column stores the chr location of the CNV.}

\item{start.column}{Which column stores the start location of the CNV.}

\item{end.column}{Which column stores the end location of the CNV.}

\item{coord.column}{CNV location in the chr:start-end format. Example: "1:538001-540000". If NULL, \code{chr.column},
\code{start.column} and {end.column} columns will be used. (Defaults to NULL)}

\item{cnv.column}{Which column stores the type of CNV (deletion or duplication).}

\item{sample.column}{Which column stores the sample name.}

\item{sample.name}{Sample name for all CNVs defined in \code{cnvs.file}. If set, \code{sample.column} is ignored (Defaults to NULL)}

\item{gene.column}{Which columns store the gene or genes affected (optional). (Defaults to NULL)}

\item{deletion}{Text used in the \code{cnv.column} to represent deletion CNVs. Multiple values are also allowed, for example: c("CN0", "CN1"). (Defaults to "deletion")}

\item{duplication}{Text used in the \code{cnv.column} to represent duplication CNVs.  Multiple values are also allowed, for example: c("CN3", "CN4") (Defaults to "duplication")}

\item{ignore.unexpected.rows}{Whether to ignore the rows which CNV \code{cnv.column} value is different to \code{deletion} or \code{duplication} values (Defaults to FALSE). It is useful for processing output from callers like LUMPY or Manta (they call also events that are not CNVs)}

\item{sep}{Separator symbol to load the csv/tsv file. (Defaults to "\\t")}

\item{skip}{Number of rows that should be skipped when reading the csv/tsv file. (Defaults to 0)}

\item{genome}{The name of the genome. (Defaults to "hg19")}

\item{exclude.non.canonical.chrs}{Whether to exclude non canonical chromosomes (Defaults to TRUE)}

\item{check.names.cnvs.file}{Whether to check \code{cnvs.file} names or not (Defaults to FALSE).  If TRUE then column names in the \code{cnvs.file} are checked to ensure that they are syntactically valid variable names. If necessary they are adjusted (by make.names) so that they are, and also to ensure that there are no duplicates}
}
\value{
A \code{GRanges} with a range per each CNV and the metadata columns:
\itemize{
 \item \code{cnv}: type of CNV, "duplication" or "deletion"
 \item \code{sample}: sample name
}

Returns NULL if \code{cnvs.file} has no CNVs
}
\description{
Loads CNV calls from a csv/tsv file
}
\details{
Loads a csv/tsv file containing CNV calls, and transform it into a GRanges with \code{cnv} and \code{sample} metadata columns.
}
\examples{
# Load CNVs data
cnvs.file <- system.file("extdata", "DECoN.CNVcalls.csv", package = "CNVfilteR", mustWork = TRUE)
cnvs.gr <- loadCNVcalls(cnvs.file = cnvs.file, chr.column = "Chromosome", start.column = "Start", end.column = "End", cnv.column = "CNV.type", sample.column = "Sample")


}
