% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphical_representations.R
\name{plotManhattan}
\alias{plotManhattan}
\title{Manhattan Plot}
\usage{
plotManhattan(all.paths, regions, chr.size.order, plot.pdf = FALSE)
}
\arguments{
\item{all.paths}{Object returned from \code{CreateFolderTree} function with 
the working folder tree}

\item{regions}{\code{\linkS4class{GRanges}} as returned by \code{\link{cnvGWAS}}}

\item{chr.size.order}{\code{\link{data.frame}} with two columns: (i) 'chr': chromosome names (character),
and (ii) 'size': length of the chromosomes in bp (integer). A \code{\linkS4class{GRanges}} containing one
chromosome per range can be used instead (the chromosomes should be in the expected order).}

\item{plot.pdf}{Logical plot a to pdf file}
}
\value{
Plots to graphics device.
}
\description{
Manhattan plot for p-values of a CNV-GWAS
}
\examples{

# Load phenotype-CNV information
data.dir <- system.file("extdata", package="CNVRanger")

phen.loc <- file.path(data.dir, "Pheno.txt")
cnv.out.loc <- file.path(data.dir, "CNVOut.txt")
map.loc <- file.path(data.dir, "MapPenn.txt")

phen.info <- setupCnvGWAS('Example', phen.loc, cnv.out.loc, map.loc)
all.paths <- phen.info$all.paths
segs.pvalue.gr <- cnvGWAS(phen.info)

# Define the chromosome order in the plot
order.chrs <- c(1:24, "25LG1", "25LG2", 27:28, "LGE22", "1A", "4A")

# Chromosome sizes
chr.size.file <- file.path(data.dir, "Parus_major_chr_sizes.txt")
chr.sizes <- scan(chr.size.file)
chr.size.order <- data.frame(chr=order.chrs, sizes=chr.sizes, stringsAsFactors=FALSE)

# Plot Manhatthan to a pdf within the 'Results' workfolder
plotManhattan(all.paths, segs.pvalue.gr, chr.size.order)

}
\author{
Vinicius Henrique da Silva
}
