% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr_assoc.R
\name{plotEQTL}
\alias{plotEQTL}
\title{Plot EQTL region}
\usage{
plotEQTL(cnvr, genes, genome, cn = "CN1", cex = 0.8)
}
\arguments{
\item{cnvr}{A \code{\linkS4class{GRanges}} of length 1, containing the genomic
coordinates of the CNV region of interest.}

\item{genes}{\code{\linkS4class{GRanges}} containing genes in the neighborhood
of the CNV region of interest.}

\item{genome}{Character. A valid UCSC genome assembly ID such as 'hg19' or 'bosTau6'.}

\item{cn}{Character. Copy number state of interest.}

\item{cex}{A numerical value giving the amount by which gene names should be 
magnified. Default is 0.8. Use smaller values to decrease font size.}
}
\value{
None. Plots to a graphics device.
}
\description{
Illustrates differential expression of genes in the neighborhood of a CNV.
}
\examples{

# CNV region of interest
cnvr <- GRanges("chr1:7908902-8336254")

# Two genes in the neighborhood
genes <- c("chr1:8021714-8045342:+", "chr1:8412464-8877699:-")
names(genes) <- c("PARK7", "RERE")
genes <- GRanges(genes)

# Annotate differential expression for 1-copy loss
genes$logFC.CN1 <- c(-0.635, -0.728)
genes$AdjPValue <- c(8.29e-09, 1.76e-08) 

# plot
plotEQTL(cnvr, genes, genome="hg19", cn="CN1")

}
\seealso{
\code{Gviz::plotTracks}
}
\author{
Ludwig Geistlinger
}
