% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossvalidateODE.R
\name{crossvalidateODE}
\alias{crossvalidateODE}
\title{Crossvalidate ODE model}
\usage{
crossvalidateODE(
  CNOlist,
  model,
  nfolds = 10,
  foldid = NULL,
  type = "datapoint",
  parallel = FALSE,
  ode_parameters = NULL,
  paramsSSm = NULL,
  method = "essm"
)
}
\arguments{
\item{CNOlist}{Cnolist which contains all the experiments}

\item{model}{a model prepared for the training}

\item{nfolds}{number of folds - default is 10. Although nfolds can be as large as the sample size (leave-one-out CV),
it is not recommended for large datasets.}

\item{foldid}{an optional vector of values between `1` and `nfold` identifying what fold each observation is in. If supplied, `nfold` can be missing.}

\item{type}{define the way to do the crossvalidation. The default is 
`type="datapoint"`, which assigns the data randomly into folds. 
The option `type="experiment"` uses whole experiments for crossvalidation 
(all data corresponding to a cue combination). The `type=observable` uses the
subset of nodes across all experiments for crossvalidation.}

\item{parallel}{use for parallel execution, requires the doParallel package}

\item{ode_parameters}{list of fitted logic ODE parameter}

\item{paramsSSm}{parameters for the SSm optimizer for running the optimization in crossvalidation}

\item{method}{Selection of optimization method: only "ga" or "essm" arguments are accepted}
}
\description{
k-fold crossvalidation for logic ODE model
}
\details{
Does a k-fold cross-validation for logic ODE CellNOpt models. In k-iterations a 
fraction of the data is eliminated from the CNOlist. The model is trained on the 
remaining data and then the model predicts the held-out data. Then the prediction
accuracy is reported for each iteration.
}
\seealso{
\code{\link{parEstimationLBode}}
}
