% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{select_genes}
\alias{select_genes}
\title{Select genes based on variance}
\usage{
select_genes(expr, n_genes, filter_pval = 0.1)
}
\arguments{
\item{expr}{A data.frame containing expression values}

\item{n_genes}{(Optional) Number of genes to be selected}

\item{filter_pval}{P-value cutoff for gene selection}
}
\value{
A vector containing the names of selected genes
}
\description{
Select genes based on variance
}
\examples{
# Get example expression data
data(expr0)
# Filter genes
expr_f <- filter_genes(expr0)
# Check selected genes
expr_f[1:5, 1:5]
# Filter genes and apply variance stabilizing transformation
expr_f2 <- filter_genes(expr0, apply_vst=TRUE)
# Check results
expr_f2[1:5, 1:5]
# Selected genes
selected <- select_genes(expr_f2)
# Get data.frame with only selected genes
expr_s <- expr_f2[selected, ]
# Check results
expr_s[1:5, 1:5]
}
