% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_hist}
\alias{plot_hist}
\alias{plot_hist,CEMiTool-method}
\title{Plot histogram}
\usage{
plot_hist(cem, ...)

\S4method{plot_hist}{CEMiTool}(cem, filter = FALSE)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}}

\item{...}{Optional parameters}

\item{filter}{Logical. Whether or not to use filtered data for CEMiTool objects (Default: FALSE).}
}
\value{
Object of class \code{CEMiTool} containing expression histogram
}
\description{
This function plots a histogram of the distribution of gene expression, to
help assess the normality of the data.
}
\examples{
# Get example CEMiTool object
data(cem)
# Plot histogram
cem <- plot_hist(cem)
# Check results
show_plot(cem, "hist")

}
