% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateCDI.R
\name{size_factor}
\alias{size_factor}
\title{Size factor of each cell}
\usage{
size_factor(X, count_slot = NULL)
}
\arguments{
\item{X}{The class of X can be "matrix", "Seurat" object, or "SingleCellExperiment" object. 
If X is a matrix, it should be a raw UMI count matrix where each row represents a gene, and 
each column represents a cell. The genes should be those before feature gene selection.
If X is a Seurat object or SingleCellExperiment object, users need to specify where the count 
matrix is stored in count_slot.}

\item{count_slot}{A string indicating the location of raw UMI count. 
For Seurat object, it is a slot in "RNA" of "assays"; 
For SingleCellExperiment object, it is a slot in "assays". 
Each row represents a gene, and each column represents a cell. 
The genes should be those before feature gene selection.}
}
\value{
A numeric vector indicating the size factor of the cells. 
This should be one of the inputs of the function calculate_CDI.
}
\description{
Different cells have different library sizes. 
This function calculates the size factor of each cell in the UMI count matrix 
to capture the variation in cell library size.
}
\examples{

ng <- 100; nc <- 100
set.seed(1)
X <- cbind(
	matrix(
		c(rnbinom(ng*nc/4, size = 1, mu = 0.1),
			rnbinom(ng*nc/4, size = 1, mu = 0.5)),
		nrow = ng, 
		byrow = TRUE),
	matrix(
		c(rnbinom(ng*nc/4, size = 1, mu = 1),
			rnbinom(ng*nc/4, size = 1, mu = 0.5)),
		nrow = ng, 
		byrow = TRUE))
colnames(X) <- paste0('c', seq_len(nc))
rownames(X) <- paste0('g', seq_len(ng))

## Input: matrix
cell_size <- size_factor(X = X)

## Input: SingleCellExperiment object
library(SingleCellExperiment)
sim_sce <- SingleCellExperiment(
  list(count = X),
  colData = data.frame(Cell_name = colnames(X)),
	 rowData = data.frame(Gene_name = rownames(X)))
cell_size <- size_factor(X = sim_sce, count_slot = "count")

## Input: Seurat object
library(Seurat)
library(SeuratObject)
sim_seurat <- CreateSeuratObject(counts = as.data.frame(X))
sim_seurat <- AddMetaData(sim_seurat, colnames(X), "Cell_name")
cell_size <- size_factor(X = sim_seurat, count_slot = "counts")

}
