% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_arrow.R
\name{cc_arrow}
\alias{cc_arrow}
\title{Paired Arrow Plot Function}
\usage{
cc_arrow(
  cc_df,
  cell_types = NULL,
  option = "A",
  n_top_ints = 15,
  exp_df = NULL,
  colours = setNames(paletteMartin(n = 2), cell_types),
  palette = "BuPu"
)
}
\arguments{
\item{cc_df}{A dataframe with columns 'source', 'target', 'ligand', 'receptor' and 'score'. See \code{toy_data} for example.}

\item{cell_types}{A vector of which two cell types to plot.}

\item{option}{Either 'A' or 'B'. Option A will plot the top \code{n_top_ints} interactions between \code{cell_types} and their scores. Option B will plot the top \code{n_top_ints} interactions between \code{cell_types}, their scores and the expression of the ligand/receptor genes in the sender/receiver cell types.}

\item{n_top_ints}{The number of top interactions to plot.}

\item{exp_df}{A dataframe containing the mean expression values for each ligand/receptor in each cell type. See \code{toy_exp} for an example. Only required for option B.}

\item{colours}{A named vector of colours for each cell type. Default is \code{paletteMartin()}, a colourblind-friendly palette. Only used for option A.}

\item{palette}{Which colour palette to use to show the mean expression. Should be one of the RColorBrewer sequential palettes. Only used for option B.}
}
\value{
Returns a plot generated with the ggplot2 package
}
\description{
This function plots interactions between a pair of cell types
}
\examples{
data(toy_data, toy_exp, package = 'CCPlotR')
cc_arrow(toy_data, cell_types = c("B", "CD8 T"), colours = c(`B` = "hotpink", `CD8 T` = "orange"))
cc_arrow(toy_data,
    cell_types = c("NK", "CD8 T"), option = "B", exp_df = toy_exp,
    n_top_ints = 10, palette = "OrRd"
)

}
