% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathwayAnalysis.R
\name{pathProbCBN}
\alias{pathProbCBN}
\title{pathProbCBN: quantifies pathway probabilities using the output of CT-CBN or H-CBN}
\usage{
pathProbCBN(dag, lambda, x)
}
\arguments{
\item{dag}{matrix representing the DAG of restrictions.}

\item{lambda}{the lambda values, which are produced by the CBN model.}

\item{x}{the number of mutations considered.}
}
\value{
vector of probabilities assigned to all potential pathways of length x
}
\description{
pathProbCBN: quantifies pathway probabilities using the output of CT-CBN or H-CBN
}
\examples{
dag <- matrix(c(2, 2, 4, 1, 3, 3), 3, 2)
lambda <- c(1, 4, 3, 2.5, 2)
x <- 4
pathP <- pathProbCBN(dag, lambda, x)
}
