% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotYields.R
\name{plotYields}
\alias{plotYields}
\title{Yield plot}
\usage{
plotYields(x, which = 0, out_path = NULL, out_name = "yield_plot")
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{which}{0, numeric or character. Specifies which barcode(s) to plot. 
Valid values are IDs that occur as row names of \code{bc_key(x)}; 
0 (the default) will generate a summary plot with all barcodes.}

\item{out_path}{character string. If specified, 
yields plots for all barcodes specified via \code{which} 
will be written to a single PDF file in this location.}

\item{out_name}{character strings specifying 
the output's file name when \code{!is.null(out_path)}; 
should be provided without(!) file type extension.}
}
\value{
a list of \code{ggplot} objects.
}
\description{
Plots the distribution of barcode separations and yields upon debarcoding 
as a function of separation cutoffs. If available, currently used separation 
cutoffs as well as their resulting yields will be indicated in the plot.
}
\details{
The overall yield that will be achieved upon application of the specified 
set of separation cutoffs is indicated in the summary plot. Respective 
separation thresholds and their resulting yields are included in each 
barcode's plot. The separation cutoff value should be chosen such that
it appropriately balances confidence in barcode assignment and cell yield.
}
\examples{
# construct SCE & apply arcsinh-transformation
data(sample_ff, sample_key)
sce <- prepData(sample_ff)

# deconvolute samples & estimate separation cutoffs
sce <- assignPrelim(sce, sample_key)
sce <- estCutoffs(sce)

# all barcodes summary plot
plotYields(sce, which = 0)

# plot for specific sample
plotYields(sce, which = "C1")

}
\references{
Zunder, E.R. et al. (2015).
Palladium-based mass tag cell barcoding with a doublet-filtering scheme 
and single-cell deconvolution algorithm.
\emph{Nature Protocols} \bold{10}, 316-333.
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
