% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScatter.R
\name{plotScatter}
\alias{plotScatter}
\title{Scatter plot}
\usage{
plotScatter(
  x,
  chs,
  color_by = NULL,
  facet_by = NULL,
  bins = 100,
  assay = "exprs",
  label = c("target", "channel", "both"),
  zeros = FALSE,
  k_pal = .cluster_cols
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{chs}{character string pecifying which channels to plot. 
Valid values are antigens: \code{rownames(x)}, 
channel names: \code{channels(x)} or non-mass
channels stored in \code{names([int_]colData(x))}, 
and should correspond to numeric variables.}

\item{color_by}{character string specifying 
a cell metadata column to color by; valid values are 
\code{names(colData(x))}, \code{names(int_colData(x))}; 
\code{names(cluster_codes(x))} (if \code{\link{cluster}} has been run);
or NULL to color by density.}

\item{facet_by}{character string specifying a non-numeric
cell metadata column to facet by; valid values are 
\code{names(colData(x))}. When \code{length(chs) == 1}, 
2 facetting variables may be provided, otherwise 1 only.}

\item{bins}{numeric of length 1 giving the number of bins 
for \code{\link[ggplot2]{geom_hex}} when coloring by density.}

\item{assay}{character string specifying which assay data to use.
Should be one of \code{assayNames(x)}.}

\item{label}{character string specifying axis labels should include
antigen targets, channel names, or a concatenation of both.}

\item{zeros}{logical specifying whether to include 0 values.}

\item{k_pal}{character string specifying the cluster color palette; 
ignored when \code{color_by} is not one of \code{names(cluster_codes(x))}. 
If less than \code{nlevels(cluster_ids(x, k))} are supplied, colors will 
be interpolated via \code{\link[grDevices:colorRamp]{colorRampPalette}}.}
}
\value{
a \code{ggplot} object.
}
\description{
Bivariate scatter plots including visualization of
(group-specific) gates, their boundaries and percentage of selected cells.
}
\examples{
data(raw_data)
sce <- prepData(raw_data)

dna_chs <- c("DNA1", "DNA2")
plotScatter(sce, dna_chs, label = "both")

plotScatter(sce, 
  chs = sample(rownames(sce), 4), 
  color_by = "sample_id")
  
sce <- prepData(sample_ff)  
ids <- sample(rownames(sample_key), 3)
sce <- assignPrelim(sce, sample_key[ids, ])
sce <- sce[, sce$bc_id \%in\% ids]

chs <- sample(rownames(sce), 5)
plotScatter(sce, chs, color_by = "bc_id")
plotScatter(sce, chs, color_by = "delta")

}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
