% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEvents.R
\name{plotEvents}
\alias{plotEvents}
\title{Event plot}
\usage{
plotEvents(
  x,
  which = "all",
  assay = "scaled",
  n = 1000,
  out_path = NULL,
  out_name = "event_plot"
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{which}{\code{"all"}, numeric or character specifying which barcode(s) to plot. 
Valid values are IDs that occur as rownames in the \code{bc_key} slot
of the input SCE's \code{metadata}, or 0 for unassigned events.}

\item{assay}{character string specifying which 
assay data slot to use. One of \code{assayNames(x)}.}

\item{n}{single numeric specifying the number of events to plot.}

\item{out_path}{character string. If specified, 
events plots for all barcodes specified via \code{which} 
will be written to a single PDF file in this location.}

\item{out_name}{character strings specifying 
the output's file name when \code{!is.null(out_path)}; 
should be provided without(!) file type extension.}
}
\value{
a list of \code{ggplot} objects.
}
\description{
Plots normalized barcode intensities for a given barcode.
}
\details{
Plots intensities normalized by population for each barcode specified
by \code{which}: Each event corresponds to the intensities plotted on a 
vertical line at a given point along the x-axis. Events are scaled to the 
95\% quantile of the population it has been assigned to. Barcodes with 
less than 50 event assignments will be skipped; it is strongly recommended
to remove such populations or reconsider their separation cutoffs.
}
\examples{
data(sample_ff, sample_key)
sce <- prepData(sample_ff, by_time = FALSE)
sce <- assignPrelim(sce, sample_key)
plotEvents(sce, which = "D1")

}
\references{
Zunder, E.R. et al. (2015).
Palladium-based mass tag cell barcoding with a doublet-filtering scheme 
and single-cell deconvolution algorithm.
\emph{Nature Protocols} \bold{10}, 316-333.
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
