% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotClusterExprs.R
\name{plotClusterExprs}
\alias{plotClusterExprs}
\title{Plot expression distributions by cluster}
\usage{
plotClusterExprs(x, k = "meta20", features = "type")
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{k}{character string specifying which clustering to use;
valid values are \code{names(cluster_codes(x))}.}

\item{features}{a character vector specifying 
which antigens to include; valid values are
\code{"type"/"state"} for \code{type/state_markers(x)} 
if \code{rowData(x)$marker_class} have been specified; 
a subset of \code{rownames(x)}; NULL to use all features.}
}
\value{
a \code{\link{ggplot}} object.
}
\description{
Plots smoothed densities of marker intensities by cluster.
}
\examples{
# construct SCE & run clustering
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

plotClusterExprs(sce, k = "meta8")

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
