% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyCutoffs.R
\name{applyCutoffs}
\alias{applyCutoffs}
\title{Single-cell debarcoding (2)}
\usage{
applyCutoffs(x, assay = "exprs", mhl_cutoff = 30, sep_cutoffs = NULL)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{assay}{character string specifying which assay data to use.
Should be one of \code{assayNames(x)} and 
correspond to expression-like not count data.}

\item{mhl_cutoff}{numeric mahalanobis distance threshold above which events 
should be unassigned; ignored if \code{metadata(x)$mhl_cutoff} exists.}

\item{sep_cutoffs}{non-negative numeric of length one or of same length 
as the number of rows in the \code{bc_key(x)}. Specifies the distance 
separation cutoffs between positive and negative barcode populations 
below which events should be unassigned. If \code{NULL} (default), 
\code{applyCutoffs} will try to access \code{metadata(x)$sep_cutoffs}.}
}
\value{
the input \code{SingleCellExperiment} \code{x} is returned with 
updated \code{colData} columns \code{"bc_id"} and \code{"mhl_dist"}, 
and an additional \code{int_metadata} slot \code{"mhl_cutoff"} 
containing the applied mahalanobies distance cutoff.
}
\description{
Applies separation and mahalanobies distance cutoffs.
}
\examples{
library(SingleCellExperiment)

# construct SCE
data(sample_ff, sample_key)
sce <- prepData(sample_ff)
    
# assign preliminary barcode IDs
# & estimate separation cutoffs
sce <- assignPrelim(sce, sample_key)
sce <- estCutoffs(sce)

# use estimated population-specific 
# vs. global separation cutoff(s)
sce1 <- applyCutoffs(sce)
sce2 <- applyCutoffs(sce, sep_cutoffs = 0.35)

# compare yields after applying cutoff(s)
c(global = mean(sce1$bc_id != 0), 
specific = mean(sce2$bc_id != 0))
  
}
\references{
Zunder, E.R. et al. (2015).
Palladium-based mass tag cell barcoding with a doublet-filtering scheme 
and single-cell deconvolution algorithm.
\emph{Nature Protocols} \bold{10}, 316-333.
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
