% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_run_carnival.R
\name{runFromLpCarnival}
\alias{runFromLpCarnival}
\title{\code{runCarnivalFromLp}}
\usage{
runFromLpCarnival(
  lpFile = "",
  parsedDataFile = "",
  carnivalOptions = defaultLpSolveCarnivalOptions()
)
}
\arguments{
\item{lpFile}{full path to .lp file}

\item{parsedDataFile}{full path to preprocessed .RData file}

\item{carnivalOptions}{the list of options for the run. See defaultLpSolveCarnivalOptions(),
defaultLpSolveCarnivalOptions, defaultCbcCarnivalOptions.}
}
\value{
The function will return a list of results containing:
1. weightedSIF: A table with 4 columns containing the combined network
solutions from CARNIVAL. It contains the Source of the interaction (Node1),
Sign of the interaction (Sign), the Target of the interaction (Node2) and the
weight of the interaction (Weight) which shows how often an interaction
appears across all solutions.

2. nodesAttributes: A table with 6 columns containing information about
infered protein activity states and attributes. It contains the Protein IDs
(Node); how often this node has taken an activity of 0, 1 and -1 across the
solutions (ZeroAct, UpAct, DownAct); the average activities across solutions
(AvgAct); and the node attribute (measured, target, inferred).

3. sifAll: A list of separate network solutions.

4. attributesAll: A list of separate inferred node activities in each
solution.

5. diagnostics: reports the convergence of optimization and reason of
the termination. Only for CPLEX solver.
}
\description{
\code{runCarnivalFromLp}
}
\details{
Runs CARNIVAL pipeline with preparsed data - lp file and Rdata file containing variables for ILP formulation.
}
\examples{
lpFilePath = system.file("toy_lp_file_ex1.lp",
                         package="CARNIVAL")

parsedDataFilePath = system.file("toy_parsed_data_ex1.RData",
                                package="CARNIVAL")

## lpSolve
#res1 = runFromLpCarnival(lpFile = lpFilePath,
#                         parsedDataFile = parsedDataFilePath,
#                         carnivalOptions = defaultLpSolveCarnivalOptions())

#res1$weightedSIF ##see @return
#res1$nodesAttributes ## see @return
#res1$sifAll ## see @return
#res1$attributesAll ## see @return

## Examples for cbc and cplex are commented out because these solvers are not part of R environment
## and need to be installed separately
##
## cbc
## res2 = runFromLpCarnival(lpFile = lpFilePath,
##                          parsedDataFile = parsedDataFilePath,
##                          carnivalOptions = defaultLpCbcCarnivalOptions())
##
## res2$weightedSIF ##see @return
## res2$nodesAttributes ## see @return
## res2$sifAll ## see @return
## res2$attributesAll ## see @return
##
## cplex
## res3 = runFromLpCarnival(lpFile = lpFilePath,
##                          parsedDataFile = parsedDataFilePath,
##                          carnivalOptions = defaultLpCplexCarnivalOptions())
##
## res3$weightedSIF ##see @return
## res3$nodesAttributes ## see @return
## res3$sifAll ## see @return
## res3$attributesAll ## see @return

}
\author{
Enio Gjerga, Olga Ivanova 2020-2021 \email{carnival.developers@gmail.com}
}
