% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARD.imputation.R
\name{Sigma}
\alias{Sigma}
\title{Calculate the variance covariance matrix used in the imputation of the
new grided locations}
\usage{
Sigma(location_orig, train_ind, test_ind, optimal_phi, ineibor)
}
\arguments{
\item{location_orig}{Data frame, spatial location data frame of the original
spatial resolved transcriptomics dataset, stored in the
spatialCoords(CARD_object)}

\item{train_ind}{Vector, index of the original spatial locations}

\item{test_ind}{Vector, index of the newly grided spatial locations}

\item{optimal_phi}{Numeric, the optimal phi value stored in CARD_object}

\item{ineibor}{Numeric, number of neighbors used in the imputation on newly
grided spatial locations, default is 10.}
}
\value{
Return a list with the imputed Cell type composition Vtest matrix on
the newly grided spatial locations and predicted normalized gene expression
}
\description{
Calculate the variance covariance matrix used in the imputation of the
new grided locations
}
