% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CARD_visualize_Cor}
\alias{CARD_visualize_Cor}
\title{Visualize the cell type proportion correlation}
\usage{
CARD_visualize_Cor(proportion, colors = colors)
}
\arguments{
\item{proportion}{Data frame, cell type proportion estimated by CARD in
either original resolution or enhanced resolution.}

\item{colors}{Vector of color names that you want to use, if NULL, we will
use the default color scale c("#91a28c","white","#8f2c37")}
}
\value{
Returns a ggcorrplot figure.
}
\description{
Visualize the cell type proportion correlation
}
\examples{
library(ggplot2)
data(spatial_count)
data(spatial_location)
data(sc_count)
data(sc_meta)
CARD_obj <- CARD_deconvolution(
    sc_count = sc_count,
    sc_meta = sc_meta,
    spatial_count = spatial_count,
    spatial_location = spatial_location,
    ct_varname = "cellType",
    ct_select = unique(sc_meta$cellType),
    sample_varname = "sampleInfo",
    mincountgene = 100,
    mincountspot = 5
)
CARD_visualize_Cor(CARD_obj$Proportion_CARD, colors = NULL)
}
