% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RleDataFrame.R
\name{rowsum.RleDataFrame}
\alias{rowsum.RleDataFrame}
\title{rowsum function for Rle DataFrames}
\usage{
\method{rowsum}{RleDataFrame}(x, group, reorder = TRUE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \code{DataFrame} containing only numerical \code{Rle} columns.}

\item{group}{a vector or factor giving the grouping, with one element per row
of \code{x}.  Missing values will be treated as another group and a warning
will be given.}

\item{reorder}{If \code{TRUE}, then the result will be in order of
\code{sort(unique(group))}, if \code{FALSE}, it will be in the order that groups
were encountered.}

\item{na.rm}{Logical (\code{TRUE} or \code{FALSE}). Should \code{NA} (including \code{NaN})
values be discarded?}

\item{...}{Other arguments to be passed to or from methods.}
}
\description{
Drop-in replacement for the \code{rowsum} function, which does not work natively
on \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}} objects containing \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle}}-encoded
numerical values.
}
\details{
See the file \code{benchmarks/rowsum_on_Rle_DF.md} in the source Git repository
of \emph{CAGEr} for the alternatives that were considered.
}
\examples{
exampleCAGEexp |> CTSStagCountDF() |>
  CAGEr:::rowsum.RleDataFrame(decode(CTSScoordinatesGR(exampleCAGEexp)$cluster), reorder = FALSE)
}
\seealso{
Other Rle DataFrames: 
\code{\link{rowSums.RleDataFrame}()}
}
\author{
Charles Plessy
}
\concept{Rle DataFrames}
