% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StrandInvaders.R
\name{flagByUpstreamSequences}
\alias{flagByUpstreamSequences}
\alias{flagByUpstreamSequences,CTSS-method}
\alias{flagByUpstreamSequences,TagClusters-method}
\alias{flagByUpstreamSequences,ConsensusClusters-method}
\alias{flagByUpstreamSequences,GRanges-method}
\title{Filter by upstream sequences}
\usage{
flagByUpstreamSequences(object, target, distance = 0)

\S4method{flagByUpstreamSequences}{CTSS}(object, target, distance = 0)

\S4method{flagByUpstreamSequences}{TagClusters}(object, target, distance = 0)

\S4method{flagByUpstreamSequences}{ConsensusClusters}(object, target, distance = 0)

\S4method{flagByUpstreamSequences}{GRanges}(object, target, distance = 0)
}
\arguments{
\item{object}{A \code{\link{CTSS}}, a \code{\link{TagClusters}}, \code{\link{ConsensusClusters}} or a
\code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}} object from which a \emph{BSgenome} object can
be reached.}

\item{target}{A target sequence.}

\item{distance}{The maximal edit distance between the genome and the target
sequence (default: 0).}
}
\value{
A \code{logical-RLe} vector indicating if ranges matched the target.
}
\description{
Looks up the bases directly upstream provided \emph{genomic ranges} and searches
for a gapless match with a \emph{target} seqence within a given edit \emph{distance}.
}
\details{
If the provided \code{object} represents \emph{tag clusters} or \emph{consensus clusters},
the search will be done upstream its \emph{dominant peak}.  Convert the object
to the \code{GRanges} class if this is not the behaviour you want.
}
\seealso{
Other CAGEr filter functions: 
\code{\link{filteredCTSSidx}()},
\code{\link{flagLowExpCTSS}()}
}
\author{
Charles Plessy
}
\concept{CAGEr filter functions}
