% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{annotateCTSS}
\alias{annotateCTSS}
\alias{annotateCTSS,CAGEexp,GRanges-method}
\alias{annotateCTSS,CAGEexp,TxDb-method}
\alias{annotateTagClusters}
\alias{annotateTagClusters,CAGEexp,GRanges-method}
\alias{annotateTagClusters,CAGEexp,TxDb-method}
\alias{annotateConsensusClusters}
\alias{annotateConsensusClusters,CAGEexp,GRanges-method}
\alias{annotateConsensusClusters,CAGEexp,TxDb-method}
\title{Annotate and compute summary statistics}
\usage{
annotateCTSS(object, annot, upstream = 500, downstream = 500)

\S4method{annotateCTSS}{CAGEexp,GRanges}(object, annot, upstream = 500, downstream = 500)

\S4method{annotateCTSS}{CAGEexp,TxDb}(object, annot)

annotateTagClusters(object, annot, upstream = 500, downstream = 500)

\S4method{annotateTagClusters}{CAGEexp,GRanges}(object, annot, upstream = 500, downstream = 500)

\S4method{annotateTagClusters}{CAGEexp,TxDb}(object, annot)

annotateConsensusClusters(object, annot, upstream = 500, downstream = 500)

\S4method{annotateConsensusClusters}{CAGEexp,GRanges}(object, annot, upstream = 500, downstream = 500)

\S4method{annotateConsensusClusters}{CAGEexp,TxDb}(object, annot)
}
\arguments{
\item{object}{\code{CAGEexp} object.}

\item{annot}{A \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}} or a \code{\link[GenomicFeatures:TxDb-class]{GenomicFeatures::TxDb}} object representing the genome
annotation.  See details for the \code{GRanges} object.}

\item{upstream}{Number of bases \emph{upstream} the start of the transcript models
to be considered as part of the \emph{promoter region}.}

\item{downstream}{Number of bases \emph{downstream} the start of the transcript
models to be considered as part of the \emph{promoter region}.}
}
\value{
\code{annotateCTSS} returns the input object with the following
modifications:
\itemize{
\item The Genomic Ranges of the \code{tagCountMatrix} experiment gains an
\code{annotation} metadata column, with levels such as \code{promoter},
\code{exon}, \code{intron} and \code{unknown}.  If the annotation has a \code{gene_name}
metadata, then a \code{genes} column is also added, with gene symbols from
the annotation.
\item The sample metadata gets new columns, indicating total counts in each of
the annotation levels.  If the annotation has a \code{gene_name} metadata, then
a \code{genes} column is added to indicate the number of different gene symbols
detected.
}

\code{annotateTagClusters} returns the input object with the same
modifications as above.

\code{annotateConsensusClusters} returns the input object with the same
modifications as above.
}
\description{
\code{annotateCTSS} annotates the \emph{CTSS} of a \code{\link{CAGEexp}} object and computes
annotation statistics.

\code{annotateConsensusClusters} annotates the \emph{consensus clusters}
of a CAGEr object.
}
\details{
If the annotation is a \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}}, gene names will be extracted from the
\code{gene_name} metadata, the \code{transcript_type} metadata will be used to filter
out entries that do not have promoters (such as immunogloblulin VDJ segments),
and the \code{type} metadata is used to extract positions of introns and exons.
}
\examples{
annotateCTSS(exampleCAGEexp, exampleZv9_annot)
colData(exampleCAGEexp)

exampleCAGEexp <- annotateTagClusters(exampleCAGEexp, exampleZv9_annot)
tagClustersGR(exampleCAGEexp, 1)

annotateConsensusClusters(exampleCAGEexp, exampleZv9_annot)
consensusClustersGR(exampleCAGEexp)

}
\seealso{
\code{\link{CTSStoGenes}}, and the \code{\link{exampleZv9_annot}} example data.

Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}

Other CAGEr annotation functions: 
\code{\link{plotAnnot}()},
\code{\link{ranges2annot}()},
\code{\link{ranges2genes}()},
\code{\link{ranges2names}()}
}
\author{
Charles Plessy
}
\concept{CAGEr annotation functions}
\concept{CAGEr object modifiers}
