% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{smoothSpatialCounts}
\alias{smoothSpatialCounts}
\title{Smooth spatial expression data}
\usage{
smoothSpatialCounts(
  bsrdm,
  areas,
  nnn = 4,
  radius = NULL,
  weight.ratio = 0.5,
  x.col = "array_col",
  y.col = "array_row"
)
}
\arguments{
\item{bsrdm}{A BSRDataModel object containing the expression data to smooth.}

\item{areas}{A data.frame containing at least the x and y
coordinates of the locations.}

\item{nnn}{Number of nearest-neighbor locations to use for smoothing
each location. In case \code{radius} is set, then it is the maximum number
of nearest neighbors within the radius.}

\item{radius}{A maximal distance to include neighbors in the smoothing.}

\item{weight.ratio}{The weight given to the central location.}

\item{x.col}{Column name in \code{areas} containing x coordinates.}

\item{y.col}{Column name in \code{areas} containing y coordinates.}
}
\value{
A BSRDataModel object containing the smoothed ncounts.
}
\description{
Smooth spatial expression data
}
\details{
The expression data contained in a BSRDataModel object are
smoothed using a weighted average of nearby locations.

Two strategies are available to identify the neighbors. It is possible to
simply set the number of nearest-neighbors (parameter \code{nnn}). An
alternative consists in providing a distance radius (\code{radius}) along
with a a maximum number of nearest-neighbors within the radius
(\code{nnn.radius}). To properly define the radius, the user must know the
location coordinates. The strategy with the radius enables having corner
locations with two neighbors only and border locations with three
neighbors only, whereas to simply set a maximum of four neighbors for
instance would retrieve the four closest neighbors in every case.

For each location, its nearest-neighbors are found and a weighted average
computed with \code{weight.ratio} given to the central location itself
and a total weight of 1-\code{weight.ratio} shared within the neighbors
based on the inverse of their distances. In case \code{radius} is set,
some locations may have less than \code{nnn} neighbors (see above).
At such locations, the weight given to
the central location is augmented according to
1-(1-\code{weight.ratio})*(number of neighbors)/\code{nnn}.
}
\examples{
 
data(bsrdm.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")
sm.bsrdm <- smoothSpatialCounts(bsrdm.spa, annotation.spa,
radius = 1.2, nnn = 4)

}
