% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{separatedLRPlot}
\alias{separatedLRPlot}
\title{Generate separated plots for a L-R interaction}
\usage{
separatedLRPlot(
  v,
  L,
  R,
  ncounts,
  areas,
  inter.name = NULL,
  rev.y = TRUE,
  ref.plot = TRUE,
  image.raster = NULL,
  x.col = "array_col",
  y.col = "array_row",
  label.col = "label",
  idSpatial.col = "idSpatial",
  cut.p = 0.01,
  low.color = "royalblue3",
  mid.color = "white",
  high.color = "orange",
  title.fs = 12,
  legend.fs = 10,
  axis.fs = 10,
  label.fs = 12,
  dot.size = 0.5,
  legend.dot.factor = 10,
  ref.colors = NULL
)
}
\arguments{
\item{v}{A named vector containing the gene signature scores for the
L-R interaction including the contribution of the pathway, names must be
the IDs of each location. Alternatively, v can be a gene signature score
matrix such as those returned by \code{scoreLRGeneSignatures} and the
row named "{\code{L}} / {\code{R}}" will be used.}

\item{L}{The name of the ligand.}

\item{R}{The name of the receptor.}

\item{ncounts}{The (normalized) expression matrix with column names equal
to the IDs of each location.}

\item{areas}{A data.frame containing at leastcluster_columns the x and y
coordinates of the locations as well as the unique IDs of spatial locations.
In case \code{ref.plot} is set to TRUE,
a label column is required additionally.}

\item{inter.name}{Interaction name to display as plot title,
equal to "\code{L} / \code{R}" unless specified.}

\item{rev.y}{A Boolean indicating whether low y coordinates should be
at the top of the plot.}

\item{ref.plot}{A Boolean indicating whether a reference map of the tissue
with area labels should be plot aside.}

\item{image.raster}{Raster object image to plot raw tissue image as
reference.}

\item{x.col}{Column name in \code{areas} containing x coordinates.}

\item{y.col}{Column name in \code{areas} containing y coordinates.}

\item{label.col}{Column name in \code{areas} containing area labels.}

\item{idSpatial.col}{Column name in \code{areas} containing the unique
IDs of spatial locations.}

\item{cut.p}{Proportion of top and bottom values for thresholding.}

\item{low.color}{Color for low score values.}

\item{mid.color}{Color for score = 0.}

\item{high.color}{Color for high score values.}

\item{title.fs}{Title font size.}

\item{legend.fs}{Legend items font size.}

\item{axis.fs}{Axis ticks font size.}

\item{label.fs}{Legend titles and axis names font size.}

\item{dot.size}{Dot size.}

\item{legend.dot.factor}{A factor applied to obtain the legend dot size.}

\item{ref.colors}{A vector of colors to bypass those automatically chosen
by ggplot2 for the tissue areas in the reference plot.}
}
\value{
A set of spatial plots.
}
\description{
Generate a detailed view related to a chosen interaction made of series of
small individual spatial plots: tissue organization (optional), gene
signature score, ligand and receptor expression.
}
\details{
A set of spatial plots are generated including an optional
reference tissue plot (image or areas represented), the gene signature
scores, the ligand expression values, and the receptor expression values.
}
\examples{
data(bsrdm.spa, package = "BulkSignalR")
data(bsrinf.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")

thres <- 0.01
bsrinf.red <- reduceToBestPathway(bsrinf.spa)
s.red  <- BSRSignature(bsrinf.red, qval.thres=thres)
scores.red <- scoreLRGeneSignatures(bsrdm.spa,s.red)

separatedLRPlot(scores.red, "SLIT2", "GPC1", 
ncounts(bsrdm.spa), 
annotation.spa,
label.col = "ground_truth")

}
