% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulatedInference.R
\name{.getRegulatedLR}
\alias{.getRegulatedLR}
\title{Get regulated ligand-receptor pairs.}
\usage{
.getRegulatedLR(
  ds,
  cc,
  scc = NULL,
  max.pval = 0.01,
  min.logFC = 1,
  neg.receptors = FALSE,
  restrict.genes = NULL
)
}
\arguments{
\item{ds}{A BSRDataModel object}

\item{cc}{A BSRClusterComp object.}

\item{scc}{An optional BSRClusterComp object in case ligand
regulation was assessed in a separate cluster comparison.}

\item{max.pval}{The maximum P-value imposed to both the ligand
and the receptor.}

\item{min.logFC}{The maximum log2 fold-change allowed for
both the receptor and the ligand.}

\item{neg.receptors}{A logical indicating whether receptors are only
allowed to be upregulated (FALSE), or up- and downregulated (TRUE).}

\item{restrict.genes}{A list of gene symbols that restricts ligands and
receptors.}
}
\value{
A data frame containing putative ligand-receptor pairs along
  with the product of their respective P-values. This table is the first step
  of a ligand-receptor analysis.
}
\description{
Internal function to return all the pairs of ligands and receptors
having both a P-value below a given threshold.
}
\details{
The \code{restrict.genes} parameter is used for special cases where
  LRdb must be further restricted to a subset.
  The putative ligand-receptor pairs has 6 columns : R, L, LR.pval, corr,
  L.logFC, and R.logFC. 
  Note that correlations are currently set to 1 to avoid
  lengthy computations with scRNA-seq data and multiple cell
  populations.
}
\keyword{internal}
