% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{.edgesLRIntracell}
\alias{.edgesLRIntracell}
\title{Internal function to generate a ligand-receptor-downstream signaling network}
\usage{
.edgesLRIntracell(
  pairs,
  pw,
  tg.genes,
  tg.corr,
  id.col,
  gene.col,
  min.cor = 0.25,
  pos.targets = FALSE,
  neg.targets = FALSE,
  tg.pval = NULL,
  max.pval = NULL,
  tg.logFC = NULL,
  min.logFC = 0
)
}
\arguments{
\item{pairs}{A ligand-receptor table such as output by
\code{LRinter(BSRInference)}.}

\item{pw}{A table defining the reference pathways.}

\item{tg.genes}{Target gene list such as output by
\code{tgGenes(BSRInference)}.}

\item{tg.corr}{Target gene correlation list (with the receptor) such as
output by \code{tgCorr(BSRInference)}.}

\item{id.col}{Column index or name in \code{pw} for the pathway IDs.}

\item{gene.col}{Column index or name in \code{pw} for the gene symbols.}

\item{min.cor}{Minimum correlation required for the target genes.}

\item{pos.targets}{A logical imposing that all the network targets must
display positive correlation or logFC a BSRInferenceComp object is used to
generate the network.}

\item{neg.targets}{A logical imposing that all the network targets must
display negative correlation or logFC a BSRInferenceComp object is used to
generate the network. Correlations must be
<= -min.cor or logFC <= - min.logFC
with this option activated.}

\item{tg.pval}{Target gene P-value list such as returned by
\code{ tgPval(BSRInferenceComp)}.}

\item{max.pval}{Maximum (regulation) P-value for target genes in case
a BSRInferenceComp object is used 
to generate the network.}

\item{min.logFC}{Minimum logFC required for the target genes in case
a BSRInferenceComp object is used to generate the network.}
}
\value{
An \code{igraph} object featuring the ligand-receptor-downstream
signaling network. Default colors and node sizes are assigned. In case
the \code{max.pval} parameter is set, it is assumed that \code{tg.pval}
is set as well and downstream signaling genes are selected by their
P-values in the comparison of clusters of samples.
}
\description{
Internal function to generate a ligand-receptor-downstream signaling network
}
\keyword{internal}
