% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrackPlotter.R
\docType{methods}
\name{xyTrack}
\alias{xyTrack}
\alias{xyTrack,TrackPlotter-method}
\alias{xyTrack}
\title{xyTrack}
\usage{
xyTrack(.Object, result.dat, gr2, min.prev = 0.15, ymax = 4.3)

\S4method{xyTrack}{TrackPlotter}(.Object, result.dat, gr2, min.prev = 0.15,
  ymax = 4.3)
}
\arguments{
\item{.Object}{the object}

\item{result.dat}{result dataframe}

\item{gr2}{gr2 object}

\item{min.prev}{previous min}

\item{ymax}{the max y}
}
\value{
the highlighted xy track
}
\description{
get the xy track
}
\examples{

load(system.file("data", "allCall.lst.RData", package="BubbleTree"))
load(system.file("data", "centromere.dat.rda", package="BubbleTree"))
load(system.file("data", "hg19.seqinfo.rda", package="BubbleTree"))

trackplotter <- new("TrackPlotter")
gr2 = centromere.dat
nn <- "sam2"
ymax <- ifelse(nn \%in\% c("lung.wgs", "lung.wes"), 9, 4.3)
p1 <- xyTrack(trackplotter,
              result.dat=allCall.lst[[nn]]@result,
              gr2=gr2,
              ymax=ymax) + ggplot2::labs(title=nn)
}
